/*
 * Decompiled with CFR 0.152.
 */
import com.smartling.api.sdk.file.FileApiClientAdapterImpl;
import com.smartling.api.sdk.file.FileApiException;
import com.smartling.api.sdk.file.FileListSearchParams;
import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.RetrievalType;
import com.smartling.api.sdk.file.parameters.FileUploadParameterBuilder;
import com.smartling.api.sdk.file.response.ApiResponse;
import com.smartling.api.sdk.file.response.EmptyResponse;
import com.smartling.api.sdk.file.response.FileLastModified;
import com.smartling.api.sdk.file.response.FileList;
import com.smartling.api.sdk.file.response.FileStatus;
import com.smartling.api.sdk.file.response.StringResponse;
import com.smartling.api.sdk.file.response.UploadData;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class SmartlingApiExample {
    private static final String API_KEY = "YOUR-API-KEY";
    private static final String PROJECT_ID = "YOUR-PROJECT-ID";
    private static final String LOCALE = "YOUR-LOCALE";
    private static final String PATH_TO_FILE = "resources/test.properties";
    private static final String FILE_ENCODING = "UTF-8";
    private static final FileType FILE_TYPE = FileType.JAVA_PROPERTIES;
    private static final String CALLBACK_URL = null;

    public static void main(String[] args) throws FileApiException {
        FileApiClientAdapterImpl smartlingFAPI = new FileApiClientAdapterImpl(true, API_KEY, PROJECT_ID);
        File file = new File(FilenameUtils.separatorsToSystem((String)PATH_TO_FILE));
        FileUploadParameterBuilder fileUploadParameterBuilder = new FileUploadParameterBuilder();
        fileUploadParameterBuilder.fileType(FILE_TYPE).fileUri(SmartlingApiExample.getFileUri(file)).approveContent(false).callbackUrl(CALLBACK_URL);
        ApiResponse<UploadData> uploadFileResponse = smartlingFAPI.uploadFile(file, FILE_ENCODING, fileUploadParameterBuilder);
        System.out.println(uploadFileResponse);
        ApiResponse<FileLastModified> lastModifiedResponse = smartlingFAPI.getLastModified(SmartlingApiExample.getFileUri(file), null, LOCALE);
        System.out.println(lastModifiedResponse);
        String fileIdentifier = "myTestFileIdentifier";
        ApiResponse<EmptyResponse> renameFileResponse = smartlingFAPI.renameFile(SmartlingApiExample.getFileUri(file), "myTestFileIdentifier");
        System.out.println(renameFileResponse);
        FileListSearchParams fileListSearchParams = new FileListSearchParams();
        fileListSearchParams.setUriMask("myTestFileIdentifier");
        ApiResponse<FileList> filesListResponse = smartlingFAPI.getFilesList(fileListSearchParams);
        System.out.println(filesListResponse);
        ApiResponse<FileStatus> fileStatusResponse = smartlingFAPI.getFileStatus("myTestFileIdentifier", LOCALE);
        System.out.println(fileStatusResponse);
        StringResponse translatedContent = smartlingFAPI.getFile("myTestFileIdentifier", LOCALE, RetrievalType.PUBLISHED);
        System.out.println(translatedContent.getContents());
        ApiResponse<EmptyResponse> deleteFileResponse = smartlingFAPI.deleteFile("myTestFileIdentifier");
        System.out.println(deleteFileResponse);
    }

    private static String getFileUri(File file) {
        return file.getName();
    }
}

