/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.cc4j.semantic.plugin.maven;

import com.smartling.cc4j.semantic.plugin.maven.AbstractVersioningMojo;
import com.smartling.cc4j.semantic.release.common.scm.ScmApiException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="version", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE)
public class ConventionalVersioningMojo
extends AbstractVersioningMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        try {
            Properties props = this.createReleaseProperties();
            this.session.getExecutionProperties().putAll((Map<?, ?>)props);
            this.writeVersionFile(props);
            this.getLog().warn((CharSequence)String.format(Locale.US, "Set release properties: %s", props));
        }
        catch (ScmApiException | IOException e) {
            throw new MojoExecutionException("SCM error: " + e.getMessage(), (Exception)e);
        }
    }

    private void writeVersionFile(Properties props) throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        File touch = new File(f, "version.props");
        try (FileOutputStream out = new FileOutputStream(touch);){
            props.store(out, "");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + touch, (Exception)e);
        }
    }
}

