/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.cc4j.semantic.plugin.maven;

import com.smartling.cc4j.semantic.plugin.maven.context.MavenConventionalVersioning;
import com.smartling.cc4j.semantic.release.common.ConventionalVersioning;
import com.smartling.cc4j.semantic.release.common.SemanticVersion;
import com.smartling.cc4j.semantic.release.common.SemanticVersionChange;
import com.smartling.cc4j.semantic.release.common.scm.ScmApiException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

abstract class AbstractVersioningMojo
extends AbstractMojo {
    private static final String MVN_RELEASE_VERSION_PROPERTY = "releaseVersion";
    private static final String MVN_DEVELOPMENT_VERSION_PROPERTY = "developmentVersion";
    @Parameter(defaultValue="${project.basedir}", required=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    File outputDirectory;
    @Parameter(defaultValue="${project.version}", required=true)
    private String versionString;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    AbstractVersioningMojo() {
    }

    ConventionalVersioning getConventionalVersioning() throws IOException {
        Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.baseDir)).build();
        MavenConventionalVersioning mvnConventionalVersioning = new MavenConventionalVersioning(repository);
        return mvnConventionalVersioning.getConventionalVersioning();
    }

    Properties createReleaseProperties() throws IOException, ScmApiException {
        ConventionalVersioning versioning = this.getConventionalVersioning();
        Properties props = new Properties();
        SemanticVersion nextVersion = versioning.getNextVersion(SemanticVersion.parse((String)this.versionString.replace("-SNAPSHOT", "")));
        SemanticVersion nextDevelopmentVersion = nextVersion.nextVersion(SemanticVersionChange.PATCH);
        props.setProperty(MVN_RELEASE_VERSION_PROPERTY, nextVersion.toString());
        props.setProperty(MVN_DEVELOPMENT_VERSION_PROPERTY, nextDevelopmentVersion.toString() + "-SNAPSHOT");
        for (MavenProject project : this.reactorProjects) {
            String projectKey = project.getGroupId() + ":" + project.getArtifactId();
            props.setProperty("project.rel." + projectKey, nextVersion.toString());
            props.setProperty("project.dev." + projectKey, nextDevelopmentVersion.toString());
        }
        return props;
    }
}

