/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobs.v3;

import com.smartling.api.jobs.v3.pto.AccountTranslationJobListItemPTO;
import com.smartling.api.jobs.v3.pto.AddLocaleCommandPTO;
import com.smartling.api.jobs.v3.pto.AsyncProcessDTO;
import com.smartling.api.jobs.v3.pto.AsyncResponsePTO;
import com.smartling.api.jobs.v3.pto.ContentProgressReportPTO;
import com.smartling.api.jobs.v3.pto.CustomFieldAssignmentPTO;
import com.smartling.api.jobs.v3.pto.CustomFieldCreatePTO;
import com.smartling.api.jobs.v3.pto.CustomFieldFilterPTO;
import com.smartling.api.jobs.v3.pto.CustomFieldPTO;
import com.smartling.api.jobs.v3.pto.CustomFieldUpdatePTO;
import com.smartling.api.jobs.v3.pto.FileUriPTO;
import com.smartling.api.jobs.v3.pto.HashcodesAndLocalesPTO;
import com.smartling.api.jobs.v3.pto.LocaleAndHashcodeListCommandPTO;
import com.smartling.api.jobs.v3.pto.LocaleHashcodePairPTO;
import com.smartling.api.jobs.v3.pto.PagingCommandPTO;
import com.smartling.api.jobs.v3.pto.SortCommandPTO;
import com.smartling.api.jobs.v3.pto.StringModifiedCountResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobAddFileCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobAuthorizeCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCancelCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCreateCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCreateResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobFindByLocalesAndHashcodesCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobFoundByStringsAndLocalesResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobGetResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobListCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobListItemPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobLocaleCompletionDatePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobRemoveFileCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobScheduleEditCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobScheduleResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobSearchCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobUpdateCommandPTO;
import com.smartling.api.jobs.v3.pto.account.AccountTranslationJobListCommandPTO;
import com.smartling.api.v2.response.EmptyData;
import com.smartling.api.v2.response.ListResponse;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/jobs-api/v3")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface TranslationJobsApi {
    public static final String API_JOBS_ENDPOINT = "/projects/{projectId}/jobs";
    public static final String API_JOBS_SEARCH_ENDPOINT = "/projects/{projectId}/jobs/search";
    public static final String API_SINGLE_JOB_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}";
    public static final String API_JOB_FIND_BY_LOCALES_AND_HASHCODES_ENDPOINT = "/projects/{projectId}/jobs/find-jobs-by-strings";
    public static final String API_JOB_CONTENTS_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/strings";
    public static final String API_JOB_ADD_STRINGS_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/strings/add";
    public static final String API_JOB_REMOVE_STRINGS_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/strings/remove";
    public static final String API_JOB_ADD_LOCALE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/locales/{localeId}";
    public static final String API_JOB_REMOVE_LOCALE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/locales/{localeId}";
    public static final String API_JOB_PROGRESS_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/progress";
    public static final String API_JOB_ADD_FILE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/file/add";
    public static final String API_JOB_FILE_PROGRESS_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/file/progress";
    public static final String API_JOB_REMOVE_FILE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/file/remove";
    public static final String API_JOB_FILES_LIST_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/files";
    public static final String API_JOB_CANCEL_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/cancel";
    public static final String API_JOB_CLOSE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/close";
    public static final String API_JOB_DELETE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}";
    public static final String API_JOB_ASYNC_PROCESSES_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/processes/{processUid}";
    public static final String API_JOB_AUTHORIZE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/authorize";
    public static final String API_JOB_LOCALES_COMPLETION_DATES_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/locales-completion-dates";
    public static final String API_AL_JOBS_ENDPOINT = "/accounts/{accountUid}/jobs";
    public static final String API_JOB_SCHEDULE_ENDPOINT = "/projects/{projectId}/jobs/{translationJobUid}/schedule";
    public static final String API_ACCOUNT_CUSTOM_FIELDS_ENDPOINT = "/accounts/{accountUid}/custom-fields";
    public static final String API_ACCOUNT_CUSTOM_FIELDS_SINGLE_FIELD_ENDPOINT = "/accounts/{accountUid}/custom-fields/{fieldUid}";
    public static final String API_PROJECT_CUSTOM_FIELDS_ENDPOINT = "/projects/{projectId}/custom-fields";
    public static final String PROJECT_ID = "projectId";
    public static final String ACCOUNT_UID = "accountUid";
    public static final String FIELD_UID = "fieldUid";
    public static final String PROCESS_UID = "processUid";
    public static final String TRANSLATION_JOB_UID = "translationJobUid";
    public static final String LOCALE_ID = "localeId";
    public static final String TARGET_LOCALE_ID = "targetLocaleId";
    public static final String FILE_URI = "fileUri";

    @GET
    @Path(value="/projects/{projectId}/jobs")
    public ListResponse<TranslationJobListItemPTO> listTranslationJobs(@PathParam(value="projectId") String var1, @BeanParam TranslationJobListCommandPTO var2, @BeanParam PagingCommandPTO var3, @BeanParam SortCommandPTO var4);

    @GET
    @Path(value="/accounts/{accountUid}/jobs")
    public ListResponse<AccountTranslationJobListItemPTO> listAccountTranslationJobs(@PathParam(value="accountUid") String var1, @BeanParam AccountTranslationJobListCommandPTO var2, @BeanParam PagingCommandPTO var3, @BeanParam SortCommandPTO var4);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}")
    public TranslationJobGetResponsePTO getTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/jobs")
    public TranslationJobCreateResponsePTO createTranslationJob(@PathParam(value="projectId") String var1, TranslationJobCreateCommandPTO var2);

    @PUT
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}")
    public TranslationJobGetResponsePTO updateTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobUpdateCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/find-jobs-by-strings")
    public ListResponse<TranslationJobFoundByStringsAndLocalesResponsePTO> findTranslationJobsByLocalesAndHashcodes(@PathParam(value="projectId") String var1, TranslationJobFindByLocalesAndHashcodesCommandPTO var2);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/strings")
    public ListResponse<LocaleHashcodePairPTO> getStringsForTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @QueryParam(value="targetLocaleId") String var3, @BeanParam PagingCommandPTO var4);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/file/remove")
    public StringModifiedCountResponsePTO removeFileFromTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobRemoveFileCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/authorize")
    public EmptyData authorizeTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobAuthorizeCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/file/add")
    public StringModifiedCountResponsePTO addFileToTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobAddFileCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/strings/add")
    public StringModifiedCountResponsePTO addOrMoveStringsToTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, LocaleAndHashcodeListCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/locales/{localeId}")
    public AsyncResponsePTO addLocaleToTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @PathParam(value="localeId") String var3, AddLocaleCommandPTO var4);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/strings/remove")
    public StringModifiedCountResponsePTO removeStringsFromTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, HashcodesAndLocalesPTO var3);

    @DELETE
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/locales/{localeId}")
    public AsyncResponsePTO removeLocaleFromTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @PathParam(value="localeId") String var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/cancel")
    public EmptyData cancelTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobCancelCommandPTO var3);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/progress")
    public ContentProgressReportPTO getTranslationJobProgress(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @QueryParam(value="targetLocaleId") String var3);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/file/progress")
    public ContentProgressReportPTO getTranslationJobFileProgress(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @QueryParam(value="fileUri") String var3, @QueryParam(value="targetLocaleId") String var4);

    @POST
    @Path(value="/projects/{projectId}/jobs/search")
    public ListResponse<TranslationJobListItemPTO> translationJobsSearch(@PathParam(value="projectId") String var1, TranslationJobSearchCommandPTO var2);

    @DELETE
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}")
    public EmptyData deleteTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/schedule")
    public ListResponse<TranslationJobScheduleResponsePTO> getSchedulesByTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/schedule")
    public ListResponse<TranslationJobScheduleResponsePTO> modifyScheduleForTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, TranslationJobScheduleEditCommandPTO var3);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/files")
    public ListResponse<FileUriPTO> getTranslationJobFiles(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @BeanParam PagingCommandPTO var3);

    @POST
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/close")
    public EmptyData closeTranslationJob(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/locales-completion-dates")
    public ListResponse<TranslationJobLocaleCompletionDatePTO> getTranslationJobLocalesCompletionDates(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/custom-fields")
    public EmptyData assignCustomFieldsToProject(@PathParam(value="projectId") String var1, List<CustomFieldAssignmentPTO> var2);

    @GET
    @Path(value="/accounts/{accountUid}/custom-fields")
    public ListResponse<CustomFieldPTO> getAccountCustomFields(@PathParam(value="accountUid") String var1, @BeanParam CustomFieldFilterPTO var2);

    @POST
    @Path(value="/accounts/{accountUid}/custom-fields")
    public CustomFieldPTO createCustomField(@PathParam(value="accountUid") String var1, CustomFieldCreatePTO var2);

    @PUT
    @Path(value="/accounts/{accountUid}/custom-fields/{fieldUid}")
    public CustomFieldPTO updateCustomField(@PathParam(value="accountUid") String var1, @PathParam(value="fieldUid") String var2, CustomFieldUpdatePTO var3);

    @GET
    @Path(value="/projects/{projectId}/jobs/{translationJobUid}/processes/{processUid}")
    public AsyncProcessDTO getProcessDetails(@PathParam(value="projectId") String var1, @PathParam(value="translationJobUid") String var2, @PathParam(value="processUid") String var3);
}

