/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobbatches.util;

import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibNameVersionHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LibNameVersionHolder.class);
    private static String clientLibName = LibNameVersionPropertiesHolder.defaultClientLibName();
    private static String clientLibVersion = LibNameVersionPropertiesHolder.defaultClientLibVersion();

    public static String getClientLibName() {
        return clientLibName;
    }

    public static void setClientLibName(String clientLibName) {
        LibNameVersionHolder.clientLibName = clientLibName;
    }

    public static String getClientLibVersion() {
        return clientLibVersion;
    }

    public static void setClientLibVersion(String clientLibVersion) {
        LibNameVersionHolder.clientLibVersion = clientLibVersion;
    }

    private static class LibNameVersionPropertiesHolder {
        private static final Properties PROPERTIES = new Properties();
        private static final String PROJECT_PROPERTIES_FILE = "sdk-project.properties";
        private static final String PROJECT_VERSION = "version";
        private static final String PROJECT_ARTIFACT_ID = "artifactId";

        private LibNameVersionPropertiesHolder() {
        }

        static String defaultClientLibName() {
            return PROPERTIES.getProperty(PROJECT_ARTIFACT_ID);
        }

        static String defaultClientLibVersion() {
            return PROPERTIES.getProperty(PROJECT_VERSION);
        }

        static {
            try {
                PROPERTIES.load(LibNameVersionPropertiesHolder.class.getClassLoader().getResourceAsStream(PROJECT_PROPERTIES_FILE));
            }
            catch (IOException e) {
                log.error(String.format("Could not read properties file=%s", PROJECT_PROPERTIES_FILE));
                throw new RuntimeException(e);
            }
        }
    }
}

