/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobbatches.v1;

import com.smartling.api.jobbatches.util.FileUploadProxyUtils;
import com.smartling.api.jobbatches.v1.JobBatchesApi;
import com.smartling.api.jobbatches.v1.pto.BatchActionRequestPTO;
import com.smartling.api.jobbatches.v1.pto.BatchPTO;
import com.smartling.api.jobbatches.v1.pto.BatchStatusResponsePTO;
import com.smartling.api.jobbatches.v1.pto.CreateBatchRequestPTO;
import com.smartling.api.jobbatches.v1.pto.CreateBatchResponsePTO;
import com.smartling.api.jobbatches.v1.pto.FileUploadPTO;
import com.smartling.api.jobbatches.v1.pto.SearchParamsPTO;
import com.smartling.api.jobbatches.v1.pto.StreamFileUploadPTO;
import com.smartling.api.v2.response.ListResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadProxy
implements JobBatchesApi {
    private static final Logger log = LoggerFactory.getLogger(FileUploadProxy.class);
    private final JobBatchesApi delegate;
    private final ResteasyClient client;
    private final ResteasyWebTarget target;

    FileUploadProxy(JobBatchesApi delegate, ResteasyClient client, ResteasyWebTarget target) {
        this.delegate = delegate;
        this.client = client;
        this.target = target;
    }

    @Override
    public CreateBatchResponsePTO createBatch(String projectId, CreateBatchRequestPTO createBatchRequest) {
        return this.delegate.createBatch(projectId, createBatchRequest);
    }

    @Override
    public BatchStatusResponsePTO getBatchStatus(String projectId, String batchUid) {
        return this.delegate.getBatchStatus(projectId, batchUid);
    }

    @Override
    public ListResponse<BatchPTO> listBatches(String projectId, SearchParamsPTO searchParams) {
        return this.delegate.listBatches(projectId, searchParams);
    }

    @Override
    public void addFile(String projectId, String batchUid, FileUploadPTO fileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        FileUploadProxyUtils.getFields(FileUploadPTO.class, output, fileUploadPTO);
        FileUploadProxyUtils.addClientLibIdIfNeeded(output);
        String path = FileUploadProxyUtils.getPathAnnotationValue(JobBatchesApi.class, "addFile", String.class, String.class, FileUploadPTO.class);
        Response response = FileUploadProxyUtils.sendRequest(this.target, path, projectId, batchUid, output);
        FileUploadProxyUtils.releaseConnection(response);
    }

    @Override
    public void addFileAsStream(String projectId, String batchUid, StreamFileUploadPTO streamFileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        FileUploadProxyUtils.getFields(StreamFileUploadPTO.class, output, streamFileUploadPTO);
        FileUploadProxyUtils.addClientLibIdIfNeeded(output);
        String path = FileUploadProxyUtils.getPathAnnotationValue(JobBatchesApi.class, "addFileAsStream", String.class, String.class, StreamFileUploadPTO.class);
        Response response = FileUploadProxyUtils.sendRequest(this.target, path, projectId, batchUid, output);
        FileUploadProxyUtils.releaseConnection(response);
    }

    @Override
    public void executeBatch(String projectId, String batchUid, BatchActionRequestPTO request) {
        this.delegate.executeBatch(projectId, batchUid, request);
    }

    @Override
    public void addFileAsync(String projectId, String batchUid, FileUploadPTO fileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        FileUploadProxyUtils.getFields(FileUploadPTO.class, output, fileUploadPTO);
        FileUploadProxyUtils.addClientLibIdIfNeeded(output);
        String path = FileUploadProxyUtils.getPathAnnotationValue(JobBatchesApi.class, "addFileAsync", String.class, String.class, FileUploadPTO.class);
        Response response = FileUploadProxyUtils.sendRequest(this.target, path, projectId, batchUid, output);
        FileUploadProxyUtils.releaseConnection(response);
    }

    @Override
    public void addFileAsStreamAsync(String projectId, String batchUid, StreamFileUploadPTO streamFileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        FileUploadProxyUtils.getFields(StreamFileUploadPTO.class, output, streamFileUploadPTO);
        FileUploadProxyUtils.addClientLibIdIfNeeded(output);
        String path = FileUploadProxyUtils.getPathAnnotationValue(JobBatchesApi.class, "addFileAsStreamAsync", String.class, String.class, StreamFileUploadPTO.class);
        Response response = FileUploadProxyUtils.sendRequest(this.target, path, projectId, batchUid, output);
        FileUploadProxyUtils.releaseConnection(response);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
        this.delegate.close();
    }
}

