/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobbatches.v2;

import com.smartling.api.jobbatches.util.LibNameVersionHolder;
import com.smartling.api.jobbatches.v2.FileUploadClientFactory;
import com.smartling.api.jobbatches.v2.FileUploadProxy;
import com.smartling.api.jobbatches.v2.JobBatchesApi;
import com.smartling.api.v2.client.AbstractApiFactory;
import com.smartling.api.v2.client.HttpClientConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class JobBatchesApiFactory
extends AbstractApiFactory<JobBatchesApi> {
    private static final int FILE_UPLOAD_SOCKET_TIMEOUT = 30000;

    protected Class<JobBatchesApi> getApiClass() {
        return JobBatchesApi.class;
    }

    public JobBatchesApi buildApi(List<ClientRequestFilter> filterList, String hostAndProtocol, HttpClientConfiguration httpClientConfiguration) {
        if (httpClientConfiguration.getSocketTimeout() == 10000) {
            httpClientConfiguration.setSocketTimeout(30000);
        }
        ArrayList<ClientRequestFilter> clientRequestFilters = new ArrayList<ClientRequestFilter>(filterList.size() + 1);
        clientRequestFilters.addAll(filterList);
        clientRequestFilters.add(this.userAgentFilter());
        JobBatchesApi jobBatchesApi = (JobBatchesApi)super.buildApi(clientRequestFilters, hostAndProtocol, httpClientConfiguration);
        ResteasyWebTarget client = new FileUploadClientFactory().build(clientRequestFilters, hostAndProtocol, httpClientConfiguration);
        return new FileUploadProxy(jobBatchesApi, client);
    }

    private ClientRequestFilter userAgentFilter() {
        return new ClientRequestFilter(){

            public void filter(ClientRequestContext clientRequestContext) {
                try {
                    clientRequestContext.getHeaders().add((Object)"User-Agent", (Object)(LibNameVersionHolder.getClientLibName() + "/" + LibNameVersionHolder.getClientLibVersion()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

