/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobbatches.v2;

import com.smartling.api.jobbatches.util.LibNameVersionHolder;
import com.smartling.api.jobbatches.v2.JobBatchesApi;
import com.smartling.api.jobbatches.v2.pto.BatchPTO;
import com.smartling.api.jobbatches.v2.pto.BatchStatusResponsePTO;
import com.smartling.api.jobbatches.v2.pto.CancelBatchActionRequestPTO;
import com.smartling.api.jobbatches.v2.pto.CreateBatchRequestPTO;
import com.smartling.api.jobbatches.v2.pto.CreateBatchResponsePTO;
import com.smartling.api.jobbatches.v2.pto.FileUploadPTO;
import com.smartling.api.jobbatches.v2.pto.RegisterBatchActionRequestPTO;
import com.smartling.api.jobbatches.v2.pto.SearchParamsPTO;
import com.smartling.api.jobbatches.v2.pto.StreamFileUploadPTO;
import com.smartling.api.v2.client.exception.RestApiExceptionHandler;
import com.smartling.api.v2.response.ListResponse;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.providers.multipart.PartFilename;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.plugins.providers.multipart.FieldEnablerPrivilegedAction;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadProxy
implements JobBatchesApi {
    private static final Logger log = LoggerFactory.getLogger(FileUploadProxy.class);
    private static final String CLIENT_LIB_ID = "smartling.client_lib_id";
    private JobBatchesApi delegate;
    private ResteasyWebTarget client;

    FileUploadProxy(JobBatchesApi delegate, ResteasyWebTarget client) {
        this.delegate = delegate;
        this.client = client;
    }

    @Override
    public CreateBatchResponsePTO createBatch(String projectId, CreateBatchRequestPTO createBatchRequest) {
        return this.delegate.createBatch(projectId, createBatchRequest);
    }

    @Override
    public BatchStatusResponsePTO getBatchStatus(String projectId, String batchUid) {
        return this.delegate.getBatchStatus(projectId, batchUid);
    }

    @Override
    public ListResponse<BatchPTO> listBatches(String projectId, SearchParamsPTO searchParams) {
        return this.delegate.listBatches(projectId, searchParams);
    }

    @Override
    public void addFileAsync(String projectId, String batchUid, FileUploadPTO fileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        this.getFields(FileUploadPTO.class, output, fileUploadPTO);
        this.addClientLibIdIfNeeded(output);
        String path = this.getPathAnnotationValue("addFileAsync", String.class, String.class, FileUploadPTO.class);
        Response response = this.sendRequest(path, projectId, batchUid, output);
        this.releaseConnection(response);
    }

    @Override
    public void addFileAsStreamAsync(String projectId, String batchUid, StreamFileUploadPTO streamFileUploadPTO) {
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        this.getFields(StreamFileUploadPTO.class, output, streamFileUploadPTO);
        this.addClientLibIdIfNeeded(output);
        String path = this.getPathAnnotationValue("addFileAsStreamAsync", String.class, String.class, StreamFileUploadPTO.class);
        Response response = this.sendRequest(path, projectId, batchUid, output);
        this.releaseConnection(response);
    }

    @Override
    public void registerFile(String projectId, String batchUid, RegisterBatchActionRequestPTO request) {
        this.delegate.registerFile(projectId, batchUid, request);
    }

    @Override
    public void cancelFile(String projectId, String batchUid, CancelBatchActionRequestPTO request) {
        this.delegate.cancelFile(projectId, batchUid, request);
    }

    private void addClientLibIdIfNeeded(MultipartFormDataOutput requestData) {
        if (!requestData.getFormData().containsKey(CLIENT_LIB_ID)) {
            String clientLibId = LibNameVersionHolder.getClientLibName() + "/" + LibNameVersionHolder.getClientLibVersion();
            requestData.addFormData(CLIENT_LIB_ID, (Object)clientLibId, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private Response sendRequest(String path, String projectId, String batchUid, MultipartFormDataOutput output) {
        RestApiExceptionHandler exceptionHandler = new RestApiExceptionHandler();
        try {
            Response response = this.client.path(path).resolveTemplate("projectId", (Object)projectId).resolveTemplate("batchUid", (Object)batchUid).request().post(Entity.entity((Object)output, (String)"multipart/form-data"));
            if (response.getStatus() != 202) {
                throw new WebApplicationException(response);
            }
            return response;
        }
        catch (WebApplicationException e) {
            throw exceptionHandler.createRestApiException((Exception)((Object)e));
        }
    }

    private void getFields(Class<?> type, MultipartFormDataOutput output, Object obj) {
        for (Field field : type.getDeclaredFields()) {
            Map directives;
            AccessController.doPrivileged(new FieldEnablerPrivilegedAction(field));
            Object value = this.getFieldValue(field, obj);
            if (value == null) continue;
            if (field.isAnnotationPresent(FormParam.class) && field.isAnnotationPresent(PartType.class)) {
                FormParam param = field.getAnnotation(FormParam.class);
                PartType partType = field.getAnnotation(PartType.class);
                String filename = this.getFilename(field);
                output.addFormData(param.value(), value, field.getType(), field.getGenericType(), MediaType.valueOf((String)partType.value()), filename);
            }
            if (!field.getType().isAssignableFrom(Map.class) || (directives = (Map)this.getFieldValue(field, obj)) == null) continue;
            for (Map.Entry entry : directives.entrySet()) {
                if (entry.getValue() == null) continue;
                output.addFormData((String)entry.getKey(), entry.getValue(), MediaType.TEXT_PLAIN_TYPE);
            }
        }
    }

    private void releaseConnection(Response response) {
        if (response instanceof ClientResponse) {
            try {
                ((ClientResponse)response).releaseConnection();
            }
            catch (IOException e) {
                log.warn("Failed to release connection for response", (Throwable)e);
            }
        }
    }

    private String getFilename(AccessibleObject method) {
        PartFilename fname = method.getAnnotation(PartFilename.class);
        return fname == null ? null : fname.value();
    }

    private Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private String getPathAnnotationValue(String methodName, Class<?> ... methodParameterTypes) {
        try {
            Method method = JobBatchesApi.class.getMethod(methodName, methodParameterTypes);
            if (method.isAnnotationPresent(Path.class)) {
                return method.getAnnotation(Path.class).value();
            }
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        return "";
    }
}

