/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.jobbatches.v1;

import com.smartling.api.jobbatches.util.FileUploadClientFactory;
import com.smartling.api.jobbatches.util.LibNameVersionHolder;
import com.smartling.api.jobbatches.v1.FileUploadProxy;
import com.smartling.api.jobbatches.v1.JobBatchesApi;
import com.smartling.api.v2.client.AbstractApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import java.util.ArrayList;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class JobBatchesApiFactory
extends AbstractApiFactory<JobBatchesApi> {
    private static final int FILE_UPLOAD_SOCKET_TIMEOUT = 30000;

    protected Class<JobBatchesApi> getApiClass() {
        return JobBatchesApi.class;
    }

    public JobBatchesApi buildApi(AuthorizationRequestFilter authFilter, ClientConfiguration config) {
        HttpClientConfiguration httpClientConfiguration = config.getHttpClientConfiguration();
        if (httpClientConfiguration.getSocketTimeout() == 10000) {
            httpClientConfiguration.setSocketTimeout(30000);
        }
        ArrayList<ClientRequestFilter> clientRequestFilters = new ArrayList<ClientRequestFilter>(config.getClientRequestFilters().size() + 1);
        clientRequestFilters.add(this.userAgentFilter());
        DefaultClientConfiguration jobsBatchConfig = DefaultClientConfiguration.builder().baseUrl(config.getBaseUrl()).httpClientConfiguration(httpClientConfiguration).clientRequestFilters(clientRequestFilters).clientResponseFilters(config.getClientResponseFilters()).resteasyProviderFactory(config.getResteasyProviderFactory()).build();
        JobBatchesApi jobBatchesApi = (JobBatchesApi)super.buildApi(authFilter, (ClientConfiguration)jobsBatchConfig);
        ArrayList<ClientRequestFilter> fileUploadFilters = new ArrayList<ClientRequestFilter>(clientRequestFilters.size() + 1);
        fileUploadFilters.add((ClientRequestFilter)authFilter);
        ResteasyWebTarget client = new FileUploadClientFactory().build(fileUploadFilters, config.getBaseUrl().toString(), httpClientConfiguration);
        return new FileUploadProxy(jobBatchesApi, client);
    }

    private ClientRequestFilter userAgentFilter() {
        return new ClientRequestFilter(){

            public void filter(ClientRequestContext clientRequestContext) {
                try {
                    clientRequestContext.getHeaders().add((Object)"User-Agent", (Object)(LibNameVersionHolder.getClientLibName() + "/" + LibNameVersionHolder.getClientLibVersion()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }
}

