/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.issues;

import com.smartling.api.v2.issues.pto.CountPTO;
import com.smartling.api.v2.issues.pto.IssueAnsweredPTO;
import com.smartling.api.v2.issues.pto.IssueAssignedUserPTO;
import com.smartling.api.v2.issues.pto.IssueCommentPTO;
import com.smartling.api.v2.issues.pto.IssueCommentTemplatePTO;
import com.smartling.api.v2.issues.pto.IssuePTO;
import com.smartling.api.v2.issues.pto.IssueSeverityLevelPTO;
import com.smartling.api.v2.issues.pto.IssueStatePTO;
import com.smartling.api.v2.issues.pto.IssueTemplatePTO;
import com.smartling.api.v2.issues.pto.IssueTextPTO;
import com.smartling.api.v2.issues.pto.IssueTextTemplatePTO;
import com.smartling.api.v2.issues.pto.IssueTypePTO;
import com.smartling.api.v2.issues.pto.IssuesFilterPTO;
import com.smartling.api.v2.issues.pto.IssuesPagingFilterPTO;
import com.smartling.api.v2.issues.pto.WatcherPTO;
import com.smartling.api.v2.issues.pto.WatcherTemplatePTO;
import com.smartling.api.v2.response.ListResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/issues-api/v2")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface IssuesApi {
    @GET
    @Path(value="/dictionary/issue-states")
    public ListResponse<IssueStatePTO> getIssueStates();

    @GET
    @Path(value="/accounts/{accountUid}/issue-types")
    public ListResponse<IssueTypePTO> getAccountIssueTypes(@PathParam(value="accountUid") String var1);

    @POST
    @Path(value="/projects/{projectId}/issues")
    public IssuePTO create(@PathParam(value="projectId") String var1, IssueTemplatePTO var2);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/issueText")
    public IssueTextPTO updateIssueText(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueTextTemplatePTO var3);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/state")
    public IssueStatePTO updateIssueState(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueStatePTO var3);

    @GET
    @Path(value="/projects/{projectId}/issues/{issueUid}")
    public IssuePTO get(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/answered")
    public IssueAnsweredPTO updateIssueAnswered(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueAnsweredPTO var3);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/assignee")
    public IssueAssignedUserPTO updateIssueAssigneeUser(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueAssignedUserPTO var3);

    @DELETE
    @Path(value="/projects/{projectId}/issues/{issueUid}/assignee")
    public void deleteIssueAssigneeUser(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/severity-level")
    public IssueSeverityLevelPTO updateIssueSeverityLevel(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueSeverityLevelPTO var3);

    @POST
    @Path(value="/projects/{projectId}/issues/{issueUid}/comments")
    public IssueCommentPTO createIssueComment(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, IssueCommentTemplatePTO var3);

    @GET
    @Path(value="/projects/{projectId}/issues/{issueUid}/comments")
    public ListResponse<IssueCommentPTO> getIssueComments(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2);

    @PUT
    @Path(value="/projects/{projectId}/issues/{issueUid}/comments/{commentUid}")
    public IssueCommentPTO updateIssueComment(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, @PathParam(value="commentUid") String var3, IssueCommentTemplatePTO var4);

    @GET
    @Path(value="/projects/{projectId}/issues/{issueUid}/comments/{commentUid}")
    public IssueCommentPTO getIssueComment(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, @PathParam(value="commentUid") String var3);

    @DELETE
    @Path(value="/projects/{projectId}/issues/{issueUid}/comments/{commentUid}")
    public void deleteIssueComment(@PathParam(value="projectId") String var1, @PathParam(value="issueUid") String var2, @PathParam(value="commentUid") String var3);

    @POST
    @Path(value="/projects/{projectId}/issues/list")
    public ListResponse<IssuePTO> getIssues(@PathParam(value="projectId") String var1, IssuesPagingFilterPTO var2);

    @POST
    @Path(value="/projects/{projectId}/issues/count")
    public CountPTO getIssuesCount(@PathParam(value="projectId") String var1, IssuesFilterPTO var2);

    @GET
    @Path(value="/accounts/{accountUid}/watchers")
    public ListResponse<WatcherPTO> getAccountWatchers(@PathParam(value="accountUid") String var1, @QueryParam(value="email") String var2, @QueryParam(value="limit") String var3, @QueryParam(value="offset") String var4);

    @POST
    @Path(value="/accounts/{accountUid}/watchers")
    public WatcherPTO createAccountWatcher(@PathParam(value="accountUid") String var1, WatcherTemplatePTO var2);

    @PUT
    @Path(value="/accounts/{accountUid}/watchers/{watcherUid}")
    public WatcherPTO updateAccountWatcher(@PathParam(value="accountUid") String var1, @PathParam(value="watcherUid") String var2, WatcherTemplatePTO var3);

    @PUT
    @Path(value="/accounts/{accountUid}/projects/{projectId}/issues/{issueUid}/watchers/{watcherUid}")
    public void addIssueWatcher(@PathParam(value="accountUid") String var1, @PathParam(value="projectId") String var2, @PathParam(value="issueUid") String var3, @PathParam(value="watcherUid") String var4);

    @DELETE
    @Path(value="/accounts/{accountUid}/projects/{projectId}/issues/{issueUid}/watchers/{watcherUid}")
    public void removeIssueWatcher(@PathParam(value="accountUid") String var1, @PathParam(value="projectId") String var2, @PathParam(value="issueUid") String var3, @PathParam(value="watcherUid") String var4);

    @GET
    @Path(value="/accounts/{accountUid}/projects/{projectId}/issues/{issueUid}/watchers")
    public ListResponse<WatcherPTO> getIssueWatchers(@PathParam(value="accountUid") String var1, @PathParam(value="projectId") String var2, @PathParam(value="issueUid") String var3);
}

