/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.files.v2;

import com.smartling.api.files.v2.pto.DeleteFilePTO;
import com.smartling.api.files.v2.pto.DownloadAllFileTranslationsPTO;
import com.smartling.api.files.v2.pto.DownloadMultipleTranslationsPTO;
import com.smartling.api.files.v2.pto.DownloadTranslationPTO;
import com.smartling.api.files.v2.pto.ExportTranslationsPTO;
import com.smartling.api.files.v2.pto.FileItemPTO;
import com.smartling.api.files.v2.pto.FileLocaleLastModifiedPTO;
import com.smartling.api.files.v2.pto.FileLocaleStatusResponse;
import com.smartling.api.files.v2.pto.FileStatusResponse;
import com.smartling.api.files.v2.pto.FileTypesListPTO;
import com.smartling.api.files.v2.pto.GetFileLastModifiedPTO;
import com.smartling.api.files.v2.pto.GetFilesListPTO;
import com.smartling.api.files.v2.pto.ImportTranslationsPTO;
import com.smartling.api.files.v2.pto.ImportTranslationsResponse;
import com.smartling.api.files.v2.pto.RenameFilePto;
import com.smartling.api.files.v2.pto.UploadFilePTO;
import com.smartling.api.files.v2.pto.UploadFileResponse;
import com.smartling.api.files.v2.resteasy.ext.TranslatedFileMultipart;
import com.smartling.api.v2.client.exception.server.DetailedErrorMessage;
import com.smartling.api.v2.response.EmptyData;
import com.smartling.api.v2.response.ListResponse;
import java.io.InputStream;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/files-api/v2")
@DetailedErrorMessage(args={"fileUri"})
public interface FilesApi
extends AutoCloseable {
    @POST
    @Path(value="/projects/{projectId}/file")
    @Consumes(value={"multipart/form-data"})
    public UploadFileResponse uploadFile(@PathParam(value="projectId") String var1, @MultipartForm UploadFilePTO var2);

    @GET
    @Path(value="/projects/{projectId}/file")
    @Produces(value={"*/*"})
    public InputStream downloadSourceFile(@PathParam(value="projectId") String var1, @QueryParam(value="fileUri") String var2);

    @GET
    @Path(value="/projects/{projectId}/file/status")
    public FileStatusResponse getFileStatus(@PathParam(value="projectId") String var1, @QueryParam(value="fileUri") String var2);

    @GET
    @Path(value="/projects/{projectId}/locales/{localeId}/file/status")
    public FileLocaleStatusResponse getFileLocaleStatus(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @QueryParam(value="fileUri") String var3);

    @GET
    @Path(value="/projects/{projectId}/locales/{localeId}/file")
    @Produces(value={"*/*"})
    public InputStream downloadTranslatedFile(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @BeanParam DownloadTranslationPTO var3);

    @GET
    @Path(value="/projects/{projectId}/locales/{localeId}/file")
    @Produces(value={"multipart/mixed"})
    public TranslatedFileMultipart downloadTranslatedFileMultipart(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @BeanParam DownloadTranslationPTO var3);

    @GET
    @Path(value="/projects/{projectId}/locales/all/file/zip")
    @Produces(value={"*/*"})
    public InputStream downloadAllFileTranslations(@PathParam(value="projectId") String var1, @BeanParam DownloadAllFileTranslationsPTO var2);

    @GET
    @Path(value="/projects/{projectId}/files/zip")
    @Produces(value={"*/*"})
    public InputStream downloadMultipleFileTranslations(@PathParam(value="projectId") String var1, @BeanParam DownloadMultipleTranslationsPTO var2);

    @GET
    @Path(value="/projects/{projectId}/files/list")
    public ListResponse<FileItemPTO> getFilesList(@PathParam(value="projectId") String var1, @BeanParam GetFilesListPTO var2);

    @GET
    @Path(value="/files-api/v2/projects/{projectId}/file-types")
    public FileTypesListPTO getFilesTypesList(@PathParam(value="projectId") String var1);

    @POST
    @Path(value="/projects/{projectId}/file/rename")
    public EmptyData renameFile(@PathParam(value="projectId") String var1, RenameFilePto var2);

    @POST
    @Path(value="/projects/{projectId}/file/delete")
    public EmptyData deleteFile(@PathParam(value="projectId") String var1, DeleteFilePTO var2);

    @GET
    @Path(value="/projects/{projectId}/file/last-modified")
    public ListResponse<FileLocaleLastModifiedPTO> getFileLastModified(@PathParam(value="projectId") String var1, @BeanParam GetFileLastModifiedPTO var2);

    @GET
    @Path(value="/projects/{projectId}/locales/{localeId}/file/last-modified")
    public FileLocaleLastModifiedPTO getFileLocaleLastModified(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @BeanParam GetFileLastModifiedPTO var3);

    @POST
    @Path(value="/projects/{projectId}/locales/{localeId}/file/import")
    @Consumes(value={"multipart/form-data"})
    public ImportTranslationsResponse importTranslations(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @MultipartForm ImportTranslationsPTO var3);

    @POST
    @Path(value="/projects/{projectId}/locales/{localeId}/file/get-translations")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"*/*"})
    public InputStream exportTranslations(@PathParam(value="projectId") String var1, @PathParam(value="localeId") String var2, @MultipartForm ExportTranslationsPTO var3);
}

