/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.files.v2.resteasy.ext;

import com.smartling.api.files.v2.resteasy.ext.TranslatedFileMetadata;
import com.smartling.api.files.v2.resteasy.ext.TranslatedFileMultipart;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;

@Provider
@Consumes(value={"multipart/mixed"})
public class TranslatedFileMultipartReader
implements MessageBodyReader<TranslatedFileMultipart> {
    private static final String BOUNDARY_PARAMETER = "boundary";
    @Context
    protected Providers workers;

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return type.equals(TranslatedFileMultipart.class);
    }

    public TranslatedFileMultipart readFrom(Class<TranslatedFileMultipart> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get(BOUNDARY_PARAMETER);
        if (null == boundary) {
            throw new IOException(Messages.MESSAGES.unableToGetBoundary());
        }
        MultipartInputImpl multipartInput = new MultipartInputImpl(mediaType, this.workers);
        multipartInput.parse(inputStream);
        if (multipartInput.getParts().size() != 2) {
            throw new IOException(String.format("The response contains unexpected number of parts (%d). Two parts are expected. The first one is file's body, the second one is metadata object.", multipartInput.getParts().size()));
        }
        InputPart filePart = (InputPart)multipartInput.getParts().get(0);
        InputPart metadataPart = (InputPart)multipartInput.getParts().get(1);
        TranslatedFileMultipart translatedFileMultipart = new TranslatedFileMultipart();
        translatedFileMultipart.multipartInput = multipartInput;
        translatedFileMultipart.fileBody = (InputStream)filePart.getBody(InputStream.class, null);
        translatedFileMultipart.fileHeaders = filePart.getHeaders();
        translatedFileMultipart.fileMediaType = filePart.getMediaType();
        MediaType metadataPartMediaType = metadataPart.getMediaType();
        if (null == metadataPartMediaType) {
            throw new IOException("Missing content type of metadata part.");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)MediaType.APPLICATION_JSON_TYPE.getType(), (CharSequence)metadataPartMediaType.getType()) || !StringUtils.equalsIgnoreCase((CharSequence)MediaType.APPLICATION_JSON_TYPE.getSubtype(), (CharSequence)metadataPartMediaType.getSubtype())) {
            throw new IOException(String.format("Unexpected content type of metadata part (%s). Expected (%s) metadata part.", metadataPart.getMediaType(), MediaType.APPLICATION_JSON_TYPE));
        }
        translatedFileMultipart.translatedFileMetadata = (TranslatedFileMetadata)metadataPart.getBody(TranslatedFileMetadata.class, TranslatedFileMetadata.class);
        if (null == translatedFileMultipart.translatedFileMetadata) {
            throw new IOException("Cannot construct metadata json object.");
        }
        return translatedFileMultipart;
    }
}

