/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.filetranslations.v2;

import com.smartling.api.filetranslations.v2.pto.file.FileUploadPTO;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadResponse;
import com.smartling.api.filetranslations.v2.pto.ld.LanguageDetectionResponse;
import com.smartling.api.filetranslations.v2.pto.ld.LanguageDetectionStatusResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtRequest;
import com.smartling.api.filetranslations.v2.pto.mt.MtResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtStatusResponse;
import com.smartling.api.v2.response.EmptyData;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/file-translations-api/v2")
public interface FileTranslationsApi {
    @POST
    @Path(value="/accounts/{accountUid}/files")
    @Consumes(value={"multipart/form-data"})
    public FileUploadResponse uploadFile(@PathParam(value="accountUid") String var1, @MultipartForm FileUploadPTO var2);

    @POST
    @Path(value="/accounts/{accountUid}/files/{fileUid}/mt")
    public MtResponse mtFile(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, MtRequest var3);

    @GET
    @Path(value="/accounts/{accountUid}/files/{fileUid}/mt/{mtUid}/status")
    public MtStatusResponse getMtProgress(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, @PathParam(value="mtUid") String var3);

    @GET
    @Path(value="/accounts/{accountUid}/files/{fileUid}/mt/{mtUid}/locales/{localeId}/file")
    @Produces(value={"*/*"})
    public InputStream downloadTranslatedFile(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, @PathParam(value="mtUid") String var3, @PathParam(value="localeId") String var4);

    @GET
    @Path(value="/accounts/{accountUid}/files/{fileUid}/mt/{mtUid}/locales/all/file/zip")
    @Produces(value={"*/*"})
    public InputStream downloadAllTranslatedFilesInZip(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, @PathParam(value="mtUid") String var3);

    @POST
    @Path(value="/accounts/{accountUid}/files/{fileUid}/mt/{mtUid}/cancel")
    public EmptyData cancelMt(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, @PathParam(value="mtUid") String var3);

    @POST
    @Path(value="/accounts/{accountUid}/files/{fileUid}/language-detection")
    public LanguageDetectionResponse detectFileSourceLanguage(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2);

    @GET
    @Path(value="/accounts/{accountUid}/files/{fileUid}/language-detection/{languageDetectionUid}/status")
    public LanguageDetectionStatusResponse getLanguageDetectionStatus(@PathParam(value="accountUid") String var1, @PathParam(value="fileUid") String var2, @PathParam(value="languageDetectionUid") String var3);
}

