/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk;

import com.smartling.api.files.v2.FilesApi;
import com.smartling.api.files.v2.FilesApiFactory;
import com.smartling.api.issues.v2.IssuesApi;
import com.smartling.api.issues.v2.IssuesApiFactory;
import com.smartling.api.jobbatches.v2.JobBatchesApi;
import com.smartling.api.jobbatches.v2.JobBatchesApiFactory;
import com.smartling.api.jobs.v3.TranslationJobsApi;
import com.smartling.api.jobs.v3.TranslationJobsApiFactory;
import com.smartling.api.locales.v2.LocalesApi;
import com.smartling.api.locales.v2.LocalesApiFactory;
import com.smartling.api.sdk.SmartlingApi;
import com.smartling.api.v2.client.ClientFactory;

final class SmartlingApiImpl
implements SmartlingApi {
    private final IssuesApi issuesApi;
    private final LocalesApi localesApi;
    private final TranslationJobsApi translationJobsApi;
    private final JobBatchesApi jobBatchesApi;
    private final FilesApi filesApi;

    SmartlingApiImpl(String userIdentifier, String userSecret) {
        this(userIdentifier, userSecret, new ClientFactory());
    }

    SmartlingApiImpl(String userIdentifier, String userSecret, ClientFactory clientFactory) {
        this.issuesApi = (IssuesApi)new IssuesApiFactory(clientFactory).buildApi(userIdentifier, userSecret);
        this.localesApi = (LocalesApi)new LocalesApiFactory(clientFactory).buildApi(userIdentifier, userSecret);
        this.translationJobsApi = (TranslationJobsApi)new TranslationJobsApiFactory(clientFactory).buildApi(userIdentifier, userSecret);
        this.jobBatchesApi = (JobBatchesApi)new JobBatchesApiFactory(clientFactory).buildApi(userIdentifier, userSecret);
        this.filesApi = (FilesApi)new FilesApiFactory(clientFactory).buildApi(userIdentifier, userSecret);
    }

    @Override
    public IssuesApi issuesApi() {
        return this.issuesApi;
    }

    @Override
    public LocalesApi localesApi() {
        return this.localesApi;
    }

    @Override
    public TranslationJobsApi translationJobsApi() {
        return this.translationJobsApi;
    }

    @Override
    public JobBatchesApi jobBatchesApi() {
        return this.jobBatchesApi;
    }

    @Override
    public FilesApi filesApi() {
        return this.filesApi;
    }
}

