/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.exception;

import com.smartling.api.v2.response.Error;
import com.smartling.api.v2.response.ErrorResponse;
import com.smartling.api.v2.response.ResponseCode;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiRuntimeException
extends WebApplicationException {
    private static final Logger log = LoggerFactory.getLogger(RestApiRuntimeException.class);
    private static final int ERRORS_LOG_LIMIT = 3;
    private static final String REQUEST_ID_HEADER = "X-SL-RequestId";
    private final ErrorResponse errorResponse;
    private String errorDetails;

    public RestApiRuntimeException(Throwable cause) {
        super(cause);
        this.errorResponse = null;
    }

    public RestApiRuntimeException(Throwable cause, Response response, ErrorResponse errorResponse) {
        super(cause, response);
        this.errorResponse = errorResponse;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public int getStatus() {
        Response response = this.getResponse();
        if (response == null) {
            return 500;
        }
        return response.getStatus();
    }

    public ResponseCode getResponseCode() {
        if (this.errorResponse == null || this.errorResponse.getCode() == null) {
            return ResponseCode.GENERAL_ERROR;
        }
        return this.errorResponse.getCode();
    }

    public List<Error> getErrors() {
        if (this.errorResponse == null || this.errorResponse.getErrors() == null) {
            return Collections.emptyList();
        }
        return this.errorResponse.getErrors();
    }

    public String getMessage() {
        String requestId = this.getResponse().getHeaderString(REQUEST_ID_HEADER);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("http_status=").append(this.getStatus());
        if (this.errorDetails != null) {
            errorMessage.append(this.errorDetails);
        }
        if (requestId != null) {
            errorMessage.append(", requestId=").append(requestId);
        }
        if (this.errorResponse != null && this.errorResponse.getErrors() != null) {
            errorMessage.append(", top errors:");
            for (int i = 0; i < this.errorResponse.getErrors().size() && i < 3; ++i) {
                Error error = this.errorResponse.getErrors().get(i);
                errorMessage.append(" '").append(error.getMessage()).append("'");
            }
        }
        return errorMessage.toString();
    }
}

