/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.exception;

import com.smartling.api.v2.client.exception.RestApiExceptionMapper;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.response.ErrorResponse;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestApiExceptionHandler.class);
    private final RestApiExceptionMapper exceptionMapper;

    public RestApiExceptionHandler(RestApiExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public RestApiRuntimeException createRestApiException(Exception exception) {
        RestApiRuntimeException restApiRuntimeException;
        Throwable throwable;
        Throwable throwable2 = throwable = exception instanceof InvocationTargetException ? exception.getCause() : exception;
        if (throwable instanceof WebApplicationException) {
            Response response = ((WebApplicationException)throwable).getResponse();
            ErrorResponse errorResponse = this.getErrorResponse(response);
            restApiRuntimeException = this.exceptionMapper.toException(throwable, response, errorResponse);
        } else {
            restApiRuntimeException = throwable instanceof ProcessingException && throwable.getCause() instanceof RestApiRuntimeException ? (RestApiRuntimeException)((Object)throwable.getCause()) : new RestApiRuntimeException(throwable);
        }
        return restApiRuntimeException;
    }

    private ErrorResponse getErrorResponse(Response response) {
        if (response == null) {
            return null;
        }
        try {
            return (ErrorResponse)response.readEntity(ErrorResponse.class);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (ProcessingException ex) {
            log.warn("Failed to process JSON: {}", (Object)ex.getMessage());
        }
        return null;
    }
}

