/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.directives;

import com.smartling.api.v2.client.directives.Directives;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.multipart.FieldEnablerPrivilegedAction;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"multipart/form-data"})
public class DirectivesAwareMultipartFormWriter
extends MultipartFormAnnotationWriter {
    protected void getFields(Class<?> type, MultipartFormDataOutput output, Object obj) throws IOException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Directives.class) || !field.isAnnotationPresent(PartType.class)) continue;
            AccessController.doPrivileged(new FieldEnablerPrivilegedAction(field));
            Directives directivesAnnotation = field.getAnnotation(Directives.class);
            String prefix = directivesAnnotation.prefix();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new WriterException((Throwable)e);
            }
            if (!(value instanceof Map)) continue;
            Map directives = (Map)value;
            for (Map.Entry directive : directives.entrySet()) {
                if (!(directive.getKey() instanceof String) || !(directive.getValue() instanceof String) && !(directive.getValue() instanceof Integer) && !(directive.getValue() instanceof Boolean)) continue;
                String directiveKey = (String)directive.getKey();
                String directiveValue = directive.getValue().toString();
                String directiveName = prefix + directiveKey;
                PartType partType = field.getAnnotation(PartType.class);
                output.addFormData(directiveName, (Object)directiveValue, String.class, String.class, MediaType.valueOf((String)partType.value()), null);
            }
        }
        super.getFields(type, output, obj);
    }
}

