<%--
Copied and modified from /libs/granite/ui/components/coral/foundation/form/pathfield/render.jsp
--%>
<%--
  ADOBE CONFIDENTIAL
  ___________________

  Copyright 2016 Adobe
  All Rights Reserved.

  NOTICE: All information contained herein is, and remains
  the property of Adobe and its suppliers, if any. The intellectual
  and technical concepts contained herein are proprietary to Adobe
  and its suppliers and are protected by all applicable intellectual
  property laws, including trade secret and copyright laws.
  Dissemination of this information or reproduction of this material
  is strictly forbidden unless prior written permission is obtained
  from Adobe.
--%><%
%><%@ include file="/libs/granite/ui/global.jsp" %><%
%><%@ page session="false"
          import="org.apache.commons.lang3.StringUtils,
                  org.apache.jackrabbit.util.Text,
                  com.adobe.granite.ui.components.AttrBuilder,
                  com.adobe.granite.ui.components.Config,
                  com.adobe.granite.ui.components.ExpressionHelper,
                  com.adobe.granite.ui.components.Field,
                  com.adobe.granite.ui.components.Tag" %><%--###
PathField
=========

.. granite:servercomponent:: /libs/granite/ui/components/coral/foundation/form/pathfield
   :supertype: /libs/granite/ui/components/coral/foundation/form/field

   A field that allows the user to enter path.

   It extends :granite:servercomponent:`Field </libs/granite/ui/components/coral/foundation/form/field>` component.

   It supports the concept of suggestion where the list of options are presented based on what the user types.
   It also supports the concept of picker where the user allows to pick the value in more advanced way (usually implemented as a dialog showing a tree view).

   **Usage Guidelines**

   In Sling, a resource (thus a path) is a first class citizen. So naturally many things, such as WCM Pages, DAM Assets, Commerce Products are represented as paths.
   This field can then be used for that purpose. However, this field is only meant for general purpose pathfield, even though the suggestion and picker can be configured.
   It is recommended to create a dedicated field for each resource type accordingly.
   e.g. It is better to create a dedicated field for the purpose of selecting CQ Pages, with the applicable configuration configured OOTB.
   This is to allow convenient usage of the said field without forcing the author to know about URL, which can be an implementation detail.

   It has the following content structure:

   .. gnd:gnd::

      [granite:FormTextField] > granite:FormField

      /**
       * The name that identifies the field when submitting the form.
       */
      - name (String)

      /**
       * A hint to the user of what can be entered in the field.
       */
      - emptyText (String) i18n

      /**
       * Indicates if the field is in disabled state.
       */
      - disabled (Boolean)

      /**
       * Indicates if the field is mandatory to be filled.
       */
      - required (Boolean)

      /**
       * The name of the validator to be applied. E.g. ``foundation.jcr.name``.
       * See :doc:`validation </jcr_root/libs/granite/ui/components/coral/foundation/clientlibs/foundation/js/validation/index>` in Granite UI.
       */
      - validation (String) multiple

      /**
       * Indicates if the user is able to select multiple selections.
       */
      - multiple (Boolean)

      /**
       * Indicates if the user must only select from the list of given options.
       * If it is not forced, the user can enter arbitrary value.
       */
      - forceSelection (Boolean)

      /**
       * ``true`` to generate the `SlingPostServlet @Delete <http://sling.apache.org/documentation/bundles/manipulating-content-the-slingpostservlet-servlets-post.html#delete>`_ hidden input based on the field name.
       */
      - deleteHint (Boolean) = true

      /**
       * The URI template that returns the suggestion markup.
       *
       * It supports the following variables:
       *
       * query
       *    The query entered by the user.
       *
       * offset
       *    The offset of the pagination.
       *
       * limit
       *    The limit of the pagination.
       */
      - suggestionSrc (StringEL)

      /**
       * The URI template that returns the picker markup.
       *
       * It supports the following variables:
       *
       * value
       *    The value of the first item.
       */
      - pickerSrc (StringEl)

      /**
       * The path of the root of the pathfield.
       */
      - rootPath (StringEL) = '/' mandatory

      /**
       * The filter applied to suggestion and picker.
       *
       * Valid values are:
       *
       * folder
       *    Shows only ``nt:folder`` nodes.
       *
       * hierarchy
       *    Shows only ``nt:hierarchyNode`` nodes.
       *
       * hierarchyNotFile
       *    Shows only ``nt:hierarchyNode`` nodes that are not ``nt:file``.
       *
       * nosystem
       *    Shows non-system nodes: ``!node.getName().startsWith("rep:") && !node.getName().equals("jcr:system")``.
       */
      - filter (String) = 'hierarchyNotFile' mandatory < 'folder', 'hierarchy', 'hierarchyNotFile', 'nosystem'
###--%><%

    Config cfg = cmp.getConfig();
    ValueMap vm = (ValueMap) request.getAttribute(Field.class.getName());

    ExpressionHelper ex = cmp.getExpressionHelper();

    final String[] values = vm.get("value", new String[0]);

    final String name = cfg.get("name", String.class);
    final boolean multiple = cfg.get("multiple", false);
    final boolean disabled = cfg.get("disabled", false);
    final int suggestionsCountLimit = cfg.get("suggestionsCountLimit", 100);

    final String defaultSuggestionSrc = "/apps/smartling-connector/content/suggestion{.offset,limit}.html?path={payload}&_charset_=utf-8{&query}";
    final String suggestionSrc = ex.getString(cfg.get("suggestionSrc", defaultSuggestionSrc));

    Tag tag = cmp.consumeTag();
    AttrBuilder attrs = tag.getAttrs();
    cmp.populateCommonAttrs(attrs);

    attrs.add("name", name);
    attrs.add("placeholder", i18n.getVar(cfg.get("emptyText", String.class)));
    attrs.addDisabled(disabled);
    attrs.addBoolean("multiple", multiple);
    attrs.addBoolean("required", cfg.get("required", false));
    attrs.addBoolean("forceselection", cfg.get("forceSelection", false));
	attrs.addClass("smartling-touch-js-coral3-language-selector-field");

    String fieldLabel = cfg.get("fieldLabel", String.class);
    String fieldDesc = cfg.get("fieldDescription", String.class);
    String labelledBy = null;

    if (fieldLabel != null && fieldDesc != null) {
        labelledBy = vm.get("labelId", String.class) + " " + vm.get("descriptionId", String.class);
    } else if (fieldLabel != null) {
        labelledBy = vm.get("labelId", String.class);
    } else if (fieldDesc != null) {
        labelledBy = vm.get("descriptionId", String.class);
    }

    if (StringUtils.isNotBlank(labelledBy)) {
        attrs.add("labelledby", labelledBy);
    }

    String labelled = cfg.get("labelled", String.class);
    if (StringUtils.isNotBlank(labelled)) {
        attrs.add("labelled", i18n.getVar(labelled));
    }
    
    if (multiple) {
        attrs.add("valuedisplaymode", "block");
    }

    attrs.add("data-foundation-validation", StringUtils.join(cfg.get("validation", new String[0]), " "));

    AttrBuilder suggestionAttrs = new AttrBuilder(request, xssAPI);
    suggestionAttrs.add("foundation-autocomplete-suggestion", "");
    suggestionAttrs.addClass("smartling-foundation-picker-buttonlist");
    suggestionAttrs.add("data-foundation-picker-buttonlist-src", request.getContextPath() + suggestionSrc);
    suggestionAttrs.add("data-foundation-picker-buttonlist-limit", suggestionsCountLimit);

    AttrBuilder valueAttrs = new AttrBuilder(request, xssAPI);
    valueAttrs.add("foundation-autocomplete-value", "");
    valueAttrs.add("name", name);

%><foundation-autocomplete <%= attrs %>>
    <coral-overlay <%= suggestionAttrs %>></coral-overlay>
    <coral-taglist <%= valueAttrs %>><%
        for (String value : values) {
            %><coral-tag value="<%= xssAPI.encodeForHTMLAttr(value) %>"><%= xssAPI.encodeForHTML(value) %></coral-tag><%
        }
    %></coral-taglist><%

    if (!StringUtils.isBlank(name)) {
        if (cfg.get("deleteHint", true)) {
            AttrBuilder deleteAttrs = new AttrBuilder(request, xssAPI);
            deleteAttrs.addClass("foundation-field-related");
            deleteAttrs.add("type", "hidden");
            deleteAttrs.add("name", name + "@Delete");
            deleteAttrs.addDisabled(disabled);
            %><input <%= deleteAttrs %>><%
        }
    }
%></foundation-autocomplete>
