;(function (document, $) {
    var LANGUAGE_SELECTOR_CLASS = '.smartling-touch-js-coral3-language-selector-field';
    var POPUP_BUTTON = 'smartling-touch-js-coral3-language-selector-popup-button';
    var CLOSE_ALL_BUTTON = 'smartling-touch-js-coral3-language-selector-close-all-button';

    $(document).on("foundation-contentloaded", function(e) {
        $(LANGUAGE_SELECTOR_CLASS).each(function (idx, selectorElement) {
            Coral.commons.ready(selectorElement, function(component){
            
                var $selector = $(selectorElement);

                var $pickerButtonGroup = $selector.find('div.coral-InputGroup .coral-InputGroup-button');

                if ($pickerButtonGroup.length === 0){
                    return;
                }

                var isStandaloneAemInstance = $pickerButtonGroup.find('._coral-Button').length === 0;

                if ($selector.find('button.' + POPUP_BUTTON).length === 0){
                    var popupButtonStandalone = '<span class="coral-InputGroup-button">' +
                        '<button class="coral3-Button coral3-Button--secondary ' + POPUP_BUTTON + '" size="M" variant="secondary" ' +
                        'title="Select Languages" type="button" aria-label="Select Languages">' +
                        '<coral-icon class="coral3-Icon coral3-Icon--sizeS coral3-Icon--chevronDown" icon="chevronDown" size="S" ' +
                        'autoarialabel="on" role="img" aria-label="chevronDown">' +
                        '</coral-icon>' +
                        '<coral-button-label></coral-button-label>' +
                        '</button>' +
                        '</span>';
                    var popupButtonCloud = '<span class="coral-InputGroup-button">' +
                        '<button tracking="off" variant="_custom" handle="button" type="button"' +
                        ' class="_coral-FieldButton _coral-Dropdown-trigger ' + POPUP_BUTTON + '" size="M">' +
                            '<svg focusable="false" aria-hidden="true" class="_coral-Icon--svg _coral-Icon _coral-UIIcon-ChevronDownMedium">' +
                                '<use xlink:href="/libs/clientlibs/granite/coralui3/resources/spectrum-css-icons.svg#spectrum-css-icon-ChevronDownMedium"></use>' +
                            '</svg>' +
                        '</button></span>';
                    var popupButton = isStandaloneAemInstance ? popupButtonStandalone : popupButtonCloud;
                    $pickerButtonGroup.before(popupButton);
                    $selector.find('button.' + POPUP_BUTTON).on('click', function(event){
                        event.stopPropagation();
                        // Coral UI applies this class for tag list without items.
                        // But it prevents from showing tag list elements.
                        $selector.find('coral-taglist').removeClass('u-coral-screenReaderOnly');
                        $selector[0]._onUserInput();
                    });
                }

                if ($selector.find('button.' + CLOSE_ALL_BUTTON).length === 0) {
                    var closeAllButtonStandalone = '<span class="coral-InputGroup-button">' +
                        '<button class="coral3-Button coral3-Button--secondary ' + CLOSE_ALL_BUTTON + '" size="M" variant="secondary" ' +
                        'title="Deselect All Languages" type="button" aria-label="Deselect All Languages">' +
                        '<coral-icon class="coral3-Icon coral3-Icon--sizeS coral3-Icon--close" icon="close" size="S" ' +
                        'autoarialabel="on" role="img" aria-label="close">' +
                        '</coral-icon>' +
                        '<coral-button-label></coral-button-label>' +
                        '</button>' +
                        '</span>';
                    var closeAllButtonCloud = '<span class="coral-InputGroup-button">' +
                        '<button tracking="off" variant="_custom" handle="button" type="button"' +
                        ' class="_coral-FieldButton _coral-Dropdown-trigger ' + CLOSE_ALL_BUTTON + '" size="M">' +
                            '<svg focusable="false" aria-hidden="true" class="_coral-Icon--svg _coral-Icon _coral-UIIcon-CrossMedium">' +
                                '<use xlink:href="/libs/clientlibs/granite/coralui3/resources/spectrum-css-icons.svg#spectrum-css-icon-CrossMedium"></use>' +
                            '</svg>' +
                        '</button></span>';
                    var closeAllButton = isStandaloneAemInstance ? closeAllButtonStandalone : closeAllButtonCloud;
                    $pickerButtonGroup.before(closeAllButton);
                    $selector.find('button.' + CLOSE_ALL_BUTTON).on('click', function(event){
                        event.stopPropagation();
                        $selector.find('coral-tagList coral-tag button').click();
                    });
                }

                $selector[0].reset = function() {
                    $selector[0].required = false;
                    $selector.find('coral-tagList coral-tag button').click();
                    setTimeout(function () {
                        $selector[0].required = true;
                    }, 200);
                    $selector[0]._getSuggestionAPI(function(api) {
                        api.cancel();
                    });
                }
            });
        });
    });

    /*
    This trick allows to avoid preliminary validation of autocomplete component
    See E-001757609 in Smartling Adobe Support console
     */
    /**
     * Statically validate the constraints of form.
     * @see {@link http://www.w3.org/TR/html5/forms.html#statically-validate-the-constraints}
     */
    function staticallyValidate(form) {
        return $(form.adaptTo("foundation-validation-helper").getSubmittables())
            .map(function() {
                var api = $(this).adaptTo("foundation-validation");

                if (api.checkValidity(/*{ suppressEvent: true }*/)) {
                    return;
                }

                return {
                    el: this,
                    api: api
                };
            }).map(function() {
                var e = $.Event("foundation-validation-invalid");
                $(this.el).trigger(e);

                if (!e.isDefaultPrevented()) {
                    return this;
                }
            });
    }

    /**
     * Interactively validate the constraints of form.
     * @see {@link http://www.w3.org/TR/html5/forms.html#interactively-validate-the-constraints}
     */
    function interactivelyValidate(form) {
        var unhandleds = staticallyValidate(form);

        if (unhandleds.length > 0) {
            unhandleds.each(function() {
                this.api.updateUI();
            });
            unhandleds[0].el.focus();
            return false;
        }

        return true;
    }

    // Use event capturing to cancel and stop propagating the event when form is invalid
    // This way no other event handlers are executed
    document.addEventListener("submit", function(e) {
        var form = $(e.target);

        if (!form.is("form") ||
            form.prop('id') !== 'create-job-form' && form.prop('id') !== 'add-to-job-form' ||
            form.prop("noValidate") === true ||
            (form.prop("noValidate") === undefined && form.attr("novalidate") !== undefined)) {
            return;
        }

        var targetLocaleCodes = form.find('foundation-autocomplete[name="targetLocaleCodes"]');
        if (targetLocaleCodes.length) {
            targetLocaleCodes[0].required = true;
        }

        // TODO For now, let's just access private data of others for prechecked
        // Once it is confirmed that this is what we want, we can simply expose adaptTo for prechecked validation
        // e.g. `var isValidPrechecked = form.adaptTo("foundation-validation-prechecked").isValid();`
        var isValidPrechecked = form.data("foundation-validation-bind.internal.valid");

        var isValid;
        if (isValidPrechecked !== undefined) {
            isValid = isValidPrechecked;
        } else {
            isValid = interactivelyValidate(form);
        }

        if (!isValid) {
            e.stopPropagation();
            e.preventDefault();
        }
    }, true);

})(document, Granite.$);
