;(function (document, $) {
    "use strict";

    window.smartling = window.smartling || {};
    window.smartling.touchui = window.smartling.touchui || {};
    window.smartling.touchui.validators = window.smartling.touchui.validators || {};
    var validators = window.smartling.touchui.validators;

    function initializeValidators() {

        var ERROR_ICON_ID = 'smartling-validation-error-icon';
        var ERROR_TOOLTIP_ID = 'smartling-validation-error-tooltip';
        var SMARTLING_DIALOG_FOOTER_SELECTOR = '#smartling-job-dialog > div._coral-Dialog > coral-dialog-footer'
        var SMARTLING_ERROR_ICON_CLASS = 'smartling-error-icon';

        function showError(message) {
            if (!message) {
                return;
            }

            if ($(SMARTLING_DIALOG_FOOTER_SELECTOR + ' #' + ERROR_ICON_ID).length === 0) {
                var icon = new Coral.Icon().set(
                    {
                        icon: 'alert',
                        size: 'L'
                    });
                icon = $(icon)
                    .attr('id', ERROR_ICON_ID)
                    .addClass(SMARTLING_ERROR_ICON_CLASS);
                var isStandaloneAemInstance = $(SMARTLING_DIALOG_FOOTER_SELECTOR).find('._coral-Button').length === 0;
                if (isStandaloneAemInstance) {
                    icon.css('margin-bottom', '1.5rem');
                }

                $(SMARTLING_DIALOG_FOOTER_SELECTOR).prepend(icon);
            }

            if ($(SMARTLING_DIALOG_FOOTER_SELECTOR + ' #' + ERROR_TOOLTIP_ID).length === 0) {
                var tooltip = new Coral.Tooltip().set({
                    content: {
                        innerHTML: message
                    },
                    variant: 'error',
                    placement: 'top',
                    target: "#" + ERROR_ICON_ID
                });
                tooltip = $(tooltip).attr('id', ERROR_TOOLTIP_ID);
                $(SMARTLING_DIALOG_FOOTER_SELECTOR).prepend(tooltip);
            }

            $(SMARTLING_DIALOG_FOOTER_SELECTOR + ' #' + ERROR_TOOLTIP_ID)[0].content.innerHTML = message;
            $(SMARTLING_DIALOG_FOOTER_SELECTOR + ' #' + ERROR_ICON_ID).show();
            $('#smartling-job-dialog').find('coral-tab[aria-selected="true"]').attr("invalid", true);
        }

        validators.hideErrorIcon = function() {
            $(SMARTLING_DIALOG_FOOTER_SELECTOR + ' #' + ERROR_ICON_ID).hide();
        }

        validators.showErrorMessage = function(response) {
            var errorText = response.responseText.startsWith('{')
                ? $.parseJSON(response.responseText).error.details[0]
                : $(response.responseText).filter('h1').html();

            showError(errorText);
            return errorText;
        }

        function processErrorResponse(response, reject) {
            var errorMessage = validators.showErrorMessage(response);

            window.smartling.touchui.jobDialog.processValidationError && window.smartling.touchui.jobDialog.processValidationError();

            reject(errorMessage);
        }

        var cloudConfigValidator = function(form) {
            return new Promise(function(resolve, reject) {
                $.ajax({
                    url: '/services/smartling/cloud/config/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        projectUid: window.smartling.touchui.jobDialog.projectUid
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var configFeatureValidator = function () {
            return new Promise(function(resolve, reject) {
                $.ajax({
                    url: '/services/smartling/config/features/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var targetLocalesValidator = function (form) {
            return new Promise(function(resolve, reject) {
                var targetLocalesElement;
                if (form.find('[name="jobUid"]').val()){
                    targetLocalesElement = $('#add-to-job-form [name="targetLocaleCodes"]');
                }else{
                    targetLocalesElement = $('#create-job-form [name="targetLocaleCodes"]');
                }
                $.ajax({
                    url: '/services/smartling/target/locales/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        targetLocaleCodes: $.map(targetLocalesElement, function(element){return element.value}),
                        projectUid: window.smartling.touchui.jobDialog.projectUid
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var sourceLocaleValidator = function (form) {
            return new Promise(function(resolve, reject) {
                $.ajax({
                    url: '/services/smartling/source/locale/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        projectUid: window.smartling.touchui.jobDialog.projectUid
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var targetParentPathValidator = function (form) {
            return new Promise(function(resolve, reject) {
                var targetLocalesElement;
                if (form.find('[name="jobUid"]').val()){
                    targetLocalesElement = $('#add-to-job-form [name="targetLocaleCodes"]');
                }else{
                    targetLocalesElement = $('#create-job-form [name="targetLocaleCodes"]');
                }
                $.ajax({
                    url: '/services/smartling/page/parent/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        targetLocaleCodes: $.map(targetLocalesElement, function(element){return element.value})
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var targetPathValidator = function (form) {
            return new Promise(function(resolve, reject) {
                if (!window.smartling.touchui.jobDialog.validateTargetContentExistence) {
                    resolve();
                    return;
                }
                var targetLocalesElement;
                if (form.find('[name="jobUid"]').val()){
                    targetLocalesElement = $('#add-to-job-form [name="targetLocaleCodes"]');
                }else{
                    targetLocalesElement = $('#create-job-form [name="targetLocaleCodes"]');
                }
                $.ajax({
                    url: '/services/smartling/page/target/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        targetLocaleCodes: $.map(targetLocalesElement, function(element){return element.value})
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var cloudConfigChildpageValidator = function () {
            return new Promise(function(resolve, reject) {
                var isDeep = $(".coral-Panel.is-selected").find("coral-checkbox [name='isDeep']").is(':checked');

                $.ajax({
                    url: '/services/smartling/cloud/config/childpage/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        isDeep: isDeep
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var jobsNameValidator = function (form) {
            return new Promise(function (resolve, reject) {
                $.ajax({
                    url: '/services/smartling/jobs/name/validator',
                    data: {
                        payload: window.smartling.touchui.jobDialog.pagePath,
                        jobName: form.find('[name="jobName"]').val(),
                        jobUid: form.find('[name="jobUid"]').val(),
                        projectUid: window.smartling.touchui.jobDialog.projectUid
                    },
                    success: resolve
                }).fail(function (response) {
                    var fieldWrapper = form.find('[name="jobName"]').parent();
                    var errorMessage = $.parseJSON(response.responseText).error.details[0];

                    fieldWrapper.find('#smartling-job-name-validator-icon').remove();
                    fieldWrapper.find('label[aria-describedby="smartling-job-name-validator-icon"]').remove();

                    var iconLabel = '<label class="coral-Form-errorlabel" aria-describedby="smartling-job-name-validator-icon" tabindex="0">' + errorMessage + '</label>';
                    var icon = new Coral.Icon().set({ icon: 'alert', size: 'S' });
                    icon = $(icon)
                        .addClass('coral-Form-fielderror')
                        .attr('id','smartling-job-name-validator-icon')
                        .addClass(SMARTLING_ERROR_ICON_CLASS);

                    fieldWrapper.append(icon);
                    fieldWrapper.append(iconLabel);

                    $('#create-job-form [name="jobName"]').attr('invalid',true);
                    $('#smartling-job-dialog').find('coral-tab[aria-selected="true"]').attr("invalid", true);

                    reject('Job name is not unique');
                });
            });
        }

        var cloudConfigMatchValidator = function (form) {
            return new Promise(function(resolve, reject) {
                var targetLocalesElement;
                if (form.find('[name="jobUid"]').val()){
                    targetLocalesElement = $('#add-to-job-form [name="targetLocaleCodes"]');
                }else{
                    targetLocalesElement = $('#create-job-form [name="targetLocaleCodes"]');
                }
                var payloadPath = window.smartling.touchui.jobDialog.pagePath;
                payloadPath = payloadPath.indexOf(';') > 0
                    ? payloadPath.substr(0, payloadPath.indexOf(';'))
                    : payloadPath;
                $.ajax({
                    url: '/services/smartling/config/match/validator',
                    data: {
                        payload: payloadPath,
                        targetLocaleCodes: $.map(targetLocalesElement, function(element){return element.value}),
                        projectUid: window.smartling.touchui.jobDialog.projectUid
                    },
                    success: resolve
                }).fail(function (response) {
                    processErrorResponse(response, reject);
                });
            });
        }

        var sourceUpdateValidator = function (form) {
            return new Promise(function(resolve, reject) {
                var targetLocaleCodes = form.find('[name="targetLocaleCodes"]')[0].values;
                var forceResubmit = form.find('coral-checkbox[name="forceResubmission"]').is('[checked]');
                var isDeep = form.find("coral-checkbox [name='isDeep']").is(':checked');
                if (!forceResubmit) {
                    $.ajax({
                        url: '/services/smartling/page/update/validator',
                        data: {
                            payload: window.smartling.touchui.jobDialog.pagePath,
                            targetLocaleCodes: targetLocaleCodes,
                            isDeep: isDeep
                        },
                        success: resolve
                    }).fail(function (response) {
                        processErrorResponse(response, reject);
                    });
                } else {
                    resolve();
                }
            });
        }

        $('#create-job-form [name="jobName"]').on('change', function(){
            $('#create-job-form label[aria-describedby="smartling-job-name-validator-icon"]').remove();
        });

        $("#create-job-form").submit(function (e) {
            validators.hideErrorIcon();

            var form = $("#create-job-form");
            if( form.data("valid") === true) {
                return;
            }

            e.preventDefault();

            Promise.all([cloudConfigValidator(form),
                configFeatureValidator(form),
                targetLocalesValidator(form),
                sourceLocaleValidator(form),
                cloudConfigMatchValidator(form),
                cloudConfigChildpageValidator(form),
                jobsNameValidator(form),
                targetParentPathValidator(form),
                targetPathValidator(form),
                sourceUpdateValidator(form)]).then(function(values) {
                    form.data("valid", true);
                    form.submit();
                    form.data("valid", false);
                }, function(reason) {
                    console.log("Validation failed with reason: " + reason);
                });

            return false;
        });

        $("#add-to-job-form").submit(function (e) {
            validators.hideErrorIcon();

            var form = $("#add-to-job-form");
            if( form.data("valid") === true) {
                return;
            }

            e.preventDefault();

            Promise.all([cloudConfigValidator(form),
                configFeatureValidator(form),
                targetLocalesValidator(form),
                sourceLocaleValidator(form),
                cloudConfigMatchValidator(form),
                cloudConfigChildpageValidator(form),
                targetParentPathValidator(form),
                targetPathValidator(form),
                sourceUpdateValidator(form)]).then(function(values) {
                form.data("valid", true);
                form.submit();
                form.data("valid", false);
            }, function(reason) {
                console.log("Validation failed with reason: " + reason);
            });

            return false;
        });
    }

    $(document).ready(initializeValidators);

})(jQuery(document), Granite.$);