;(function (document, $) {

    window.smartling = window.smartling || {};
    window.smartling.touchui = window.smartling.touchui || {};
    window.smartling.touchui.jobDialog = window.smartling.touchui.jobDialog || {};
    var dialog = window.smartling.touchui.jobDialog;

    window.smartling.touchui.jobSelector = window.smartling.touchui.jobSelector || {};
    var jobSelector = window.smartling.touchui.jobSelector;
    window.smartling.touchui.validators = window.smartling.touchui.validators || {};
    var validators = window.smartling.touchui.validators;

    dialog.putCustomFields = function(formId) {
        var dialogContent = $('coral-dialog#smartling-job-dialog').find('coral-dialog-content').first();
        if (!dialogContent.length || dialogContent.hasClass('smartling-custom-fields-requested') && !formId) {
            return;
        }
        dialogContent.addClass('smartling-custom-fields-requested');
        $.ajax({
            url: '/services/smartling/project/custom-fields?path=' + dialog.pagePath + '&projectUid=' + dialog.projectUid
        }).done(function (data){
            $('#smartling-job-dialog form').each(function (formIndex) {
                var thisForm = $(this);
                if (!formId || formId === thisForm.attr('id')) {
                    dialog.putCustomFieldsOnForm(thisForm, formIndex, data);
                }
            });
            $('#smartling-job-dialog').get(0).center();
        });
    }

    dialog.putCustomFieldsOnForm = function(form, formIndex, data) {
        form.find('.smartling-custom-fields-label').remove();
        form.find('.smartling-custom-field').remove();
        data.forEach(function (elem) {
            if (elem.fieldType !== 'SHORT_TEXT' && elem.fieldType !== 'LONG_TEXT') {
                return ;
            }
            var customFieldsLabelElement = '<div class="coral-Form-fieldwrapper"><label class="coral-Form-fieldlabel smartling-custom-fields-label"style="font-size:larger">Custom Fields</label></div>';
            var customFieldWrapperElement = '<div class="coral-Form-fieldwrapper smartling-custom-field"></div>';
            if (form.find('.smartling-custom-fields-label').length === 0) {
                form.append(customFieldsLabelElement);
            }

            var customFieldWrapper = $(customFieldWrapperElement)
            form.append(customFieldWrapper);
            var textField = (elem.fieldType === 'SHORT_TEXT')
                    ? new Coral.Textfield()
                    : new Coral.Textarea();
            textField.name = 'uid-' + elem.fieldUID;
            textField.classList.add('coral-Form-field');
            textField.classList.add('uid-' + elem.fieldUID + '-custom-field');
            textField.classList.add(elem.fieldType + '-custom-field-type');
            textField.id = 'uid-' + elem.fieldUID + '-field' + formIndex;
            customFieldWrapper.append('<label class="coral-Form-fieldlabel" id="uid-' + elem.fieldUID + '-label' + formIndex + '">' + elem.fieldName + '</label>');
            if (elem.description) {
                var icon = new Coral.Icon().set({
                    icon: 'infoCircle',
                    id: 'uid-' + elem.fieldUID + '-icon' + formIndex
                });
                icon.classList.add('coral-Form-fieldinfo');
                var tooltip = new Coral.Tooltip().set({
                    content: {
                        innerHTML: elem.description
                    },
                    placement: 'top',
                    target: '#uid-' + elem.fieldUID + '-icon' + formIndex
                });
                tooltip.id = 'uid-' + elem.fieldUID + '-tooltip' + formIndex;
                customFieldWrapper.append(icon);
                customFieldWrapper.append(tooltip);
                $('#uid-' + elem.fieldUID + '-tooltip' + formIndex)[0].target = '#uid-' + elem.fieldUID + '-icon' + formIndex;
            }
            customFieldWrapper.append(textField);
        });
    }

    dialog.loadProjects = function(path) {
        var foundationUi = $(window).adaptTo('foundation-ui');
        function fillProjectSelect(select, data) {
            select.items.clear();
            data.forEach(function (project) {
                select.items.add({
                    selected: project.isSelected,
                    value: project.projectUid,
                    content: {innerHTML: project.projectName + ' (' + project.projectSourceLocale + ')'}
                });
                if (project.isSelected) {
                    dialog.projectUid = project.projectUid;
                }
            });

            dialog.putCustomFields();
            jobSelector.init();
            validators.hideErrorIcon();
        }

        $('#smartling-job-dialog #smartling-project-select').each(function() {
            var select = this;

            if (select.getAttribute('payload') === path && dialog.projectUid && select.selectedItem || select.loading) {
                return;
            }

            if ((dialog.reuseProjectSelectData || select.getAttribute('payload') === path) && dialog.projectSelectData) {
                fillProjectSelect(select, dialog.projectSelectData);
                select.loading = false;
                select.setAttribute('payload', path);
                return;
            }
            var form = $(this).closest('form').get(0);
            foundationUi.wait(form);
            select.loading = true;
            $.ajax({
                url: '/services/smartling/project-configs?path=' + path
            }).done(function (data) {
                dialog.projectSelectData = data;
                fillProjectSelect(select, dialog.projectSelectData);
            }).fail(validators.showErrorMessage
            ).always(function () {
                foundationUi.clearWait();
                select.loading = false;
            });

            select.setAttribute('payload', path);
        });
    }

    dialog.loadDialogOptions = function() {
        $.ajax({
            url: '/services/smartling/dialog-options'
        }).done(function (data) {
            $('#smartling-job-dialog coral-checkbox[name="authorizeJob"]').each(function(){
                this.checked = data.autoAuthorize;
            });
            $('#smartling-job-dialog coral-checkbox[name="pseudo"]').each(function(){
                this.checked = data.pseudo;
            });
            dialog.validateTargetContentExistence = data.validateTargetContentExistence;
        }).fail(validators.showErrorMessage);
    }

    dialog.openDialog = function(path) {
        var $dialog = $('#smartling-job-dialog');
        if (!$dialog.length) {
            return;
        }

        dialog.setPayload(path);
        dialog.loadProjects(path);
        dialog.loadDialogOptions();
        $dialog.get(0).show();
        jobSelector.init();
    }

    dialog.closeDialog = function () {
        var $dialog = $('#smartling-job-dialog');
        if (!$dialog.length) {
            return;
        }
        $dialog.get(0).hide();
    }

    dialog.setPayload = function(payload) {
        if (payload) {
            payload = payload.replace(/\.html.*$/, "")
            $('#smartling-job-dialog input[name="payload"]').val(payload);
            dialog.pagePath = payload;
        }
    }

    dialog.setReuseProjectSelectData = function(val) {
        dialog.reuseProjectSelectData = val;
    }

    dialog.getPayload = function() {
        return dialog.pagePath;
    }

    dialog.initializeForm = function(action) {
        var foundationUi = $(window).adaptTo('foundation-ui');
        var $dialog = $('#smartling-job-dialog');

        if (!$dialog.length) {
            return;
        }

        var $tabs = $('#smartling-job-dialog-tabs');

        $dialog.find('form').each(function() {
           $(this).attr('action', action);
        });

        $dialog.find('coral-datepicker').each(function () {
            this.min = moment().startOf('day').toDate();
        });

        $dialog.find('form')
            .on('foundation-form-submitted', function (e, success) {
                if (success) {
                    dialog.closeDialog();
                    foundationUi.notify('Success', 'Page was queued into AEM Translation Workflow', 'success');
                }
            })
            .on('reset', function () {
                this.querySelector('coral-checkbox[name="authorizeJob"]').checked = true;
                this.querySelector('coral-checkbox[name="isDeep"]') &&
                    (this.querySelector('coral-checkbox[name="isDeep"]').checked = false);
                this.querySelector('coral-checkbox[name="forceResubmission"]') &&
                    (this.querySelector('coral-checkbox[name="forceResubmission"]').checked = true);
                $(this).find('.coral-Form-field[name="jobName"]').val('');

                $('.smartling-touch-js-language-selector-field').each(function () {
                    var $selector = $(this);
                    var languageSelectorField = CUI.Widget.fromElement('Autocomplete', $selector);
                    languageSelectorField.reset();
                });
            });

        $('#smartling-job-select').on('coral-select:showitems', function (e) {
            var select = this;

            if (select.items.length === 0) {
                e.preventDefault();

                $.ajax({
                    url: '/services/smartling/jobs?path=' + dialog.pagePath + '&projectUid=' + dialog.projectUid
                }).done(function (data) {
                    data.forEach(function (job) {
                        var redableState;
                        if (job.state == 'AWAITING_AUTHORIZATION') {
                            redableState = '(Unauthorized)';
                        } else if (job.state == 'IN_PROGRESS') {
                            redableState = '(In progress)';
                        } else if (job.state == 'COMPLETED') {
                            redableState = '(Completed)'
                        }
                        else {
                            redableState = '(' + job.state + ')'
                        }
                        select.items.add({value: job.uid, content: {innerHTML: job.name + ' ' + redableState}});
                    });
                    validators.hideErrorIcon();
                }).fail(validators.showErrorMessage
                ).always(function () {
                    select.loading = false;
                });
            }
        }).on('change', function (e) {
            if (!e.target.value) {
                return;
            }
            var form = $(this).closest('form').get(0);
            var dueDateFiled = form.querySelector('coral-datepicker[name="jobDueDate"]');
            var $targetLocalesField = $(form.querySelector('[name="targetLocaleCodes"]').closest('.coral-Form-field'));
            var $tagList = $targetLocalesField.find('[name="targetLocaleCodes"]')
            $tagList.removeClass('u-coral-screenReaderOnly');

            foundationUi.wait(form);
            $.ajax({
                url: '/services/smartling/jobs/detail?path=' + dialog.pagePath + '&uid=' + e.target.value + '&projectUid=' + dialog.projectUid
            }).done(function (data) {
                dueDateFiled.value = data.dueDate;
                var selections = [];
                data.targetLocales && data.targetLocales.forEach(function(elem) {
                    selections.push({
                        value: elem.code,
                        text: elem.label
                    })
                });
                $tagList.empty();
                $targetLocalesField[0].required = false;
                setTimeout(function () {
                    $targetLocalesField[0].required = true;
                }, 200);

                $targetLocalesField[0]._setSelections(selections);

                $(form).find('.smartling-custom-field input').val('');
                data.customFields && data.customFields.forEach(function (elem) {
                    var fieldInput = $(form).find('.uid-' + elem.fieldUid + '-custom-field');
                    if (!fieldInput.hasClass('SHORT_TEXT-custom-field-type') && !fieldInput.hasClass('LONG_TEXT-custom-field-type')) {
                        return ;
                    }
                    fieldInput.val(elem.fieldValue);
                });
                validators.hideErrorIcon();
            }).fail(function (response) {
                dueDateFiled.value = null;
                $targetLocalesField.find('[name="targetLocaleCodes"]').empty();
                validators.showErrorMessage(response);
            }).always(function () {
                foundationUi.clearWait();
            });
        });

        $('#smartling-job-dialog #smartling-project-select').on('change', function (e) {
            if (!e.target.value) {
                return;
            }
            var select = this;
            dialog.projectUid = select.selectedItem.value;

            var form = $(select).closest('form');
            dialog.putCustomFields(form.attr('id'));
            jobSelector.init();
        });

        $tabs.on('coral-panelstack:change', function() {
            var $submitButton = $('#smartling-job-dialog-submit');
            var $form = $(this.panelStack.selectedItem).find('form');
            $submitButton.attr('form', $form.attr('id'));

            $(".coral-Form-fielderror").hide();
            $(".coral-Form-field").removeAttr("invalid");
            $(".coral-Tab").removeAttr("invalid");

            dialog.projectUid = $form.find('#smartling-project-select')[0].value;
        });

        $tabs.find("coral-tab").on('click', function() {
            var $submitButton = $('#smartling-job-dialog-submit');
            if ($submitButton.length) {
                $submitButton.get(0).label.innerText = $(this).find("coral-tab-label").text();
            }
        });

        $dialog.on('coral-overlay:close', '*', function (e) {
            e.stopPropagation();
        }).on('coral-overlay:close', function () {
            var $forms = $(this).find('form');

            $forms.each(function () {
                var $form = $(this);
                var PAGE_THUMBNAIL = 'cq-wcm-pagethumbnail';
                if ($form.find("." + PAGE_THUMBNAIL).length === 0) {
                    var $div = $('<div/>').addClass(PAGE_THUMBNAIL).hide();
                    var $button = $('<button/>').attr({type:'reset'}).hide();
                    $div.data("cq-wcm-pagethumbnail.internal.original", [{"outerHTML":""}]);
                    $div.append($button);
                    $form.append($div);
                }
                var $targetLocalesField = $form.find('[name="targetLocaleCodes"]').closest('.coral-Form-field');
                $targetLocalesField[0].reset();
                this.reset();
            });

            $(".coral-Form-fielderror").hide();
            $(".coral-Form-field").removeAttr("invalid");
            $(".coral-Tab").removeAttr("invalid");
            $tabs.get(0).tabList.items.first().selected = true;
        });

        $("#create-job-form").find('[name="jobName"]').on("input", function () {
            if ($("#create-job-form").find('[name="jobName"]').attr("aria-invalid") === "true") {
                $("#create-job-form").find('[name="jobName"]').parent().find(".coral-Form-fielderror").hide();
            }
        });

        $dialog.on("foundation-validation-invalid", function (event) {
            var target = $(event.target);
            target.parent().find(".coral-Form-fielderror").show();
        });
    }

})(jQuery(document), Granite.$);
