;(function (document, $) {
    window.smartling = window.smartling || {};
    window.smartling.touchui = window.smartling.touchui || {};
    window.smartling.touchui.jobSelector = window.smartling.touchui.jobSelector || {};
    var jobSelector = window.smartling.touchui.jobSelector;
    window.smartling.touchui.jobDialog = window.smartling.touchui.jobDialog || {};
    var dialog = window.smartling.touchui.jobDialog;
    var ATTR_FILTER_READY_FOR_PROJECT = "data-select-filter-project";
    var SMARTLING_TOUCH_UI_SELECT_JOB_FILTER = "smartling-touch-ui-select-job-filter";

    jobSelector.newFilterTextField = function() {
        var filter = new Coral.Textfield();
        filter.classList.add("coral-Form-field");
        filter.classList.add(SMARTLING_TOUCH_UI_SELECT_JOB_FILTER);
        filter.placeholder = "Type name of Smartling Job here";
        return filter;
    }

    jobSelector.isValidSelectDomStruture = function(selectEl) {
        var overlay = selectEl.querySelector("coral-overlay");
        var selectList = overlay ? overlay.querySelector("coral-selectlist") : null;
        var items = selectList ? selectList.items : false;
        return !!overlay && !!selectList && !!items;
    }

    jobSelector.filterSelectList = function(selectListEl, filterText) {
        if (!selectListEl || !filterText) {
            return;
        }
        selectListEl.items.getAll().forEach(function(item) {
            var itemText = item.textContent;
            var bothNotEmpty = itemText && filterText;
            var match =
                bothNotEmpty &&
                itemText.toLowerCase().indexOf(filterText.toLowerCase()) > -1;
            var eitherIsEmpty = !itemText || !filterText;
            if (eitherIsEmpty || match) {
                item.show();
            } else {
                item.hide();
            }
        });
    }

    jobSelector.showAllItems = function (selectList) {
        var selectEl = $('#smartling-job-select').get(0);
        if (selectEl.getAttribute(ATTR_FILTER_READY_FOR_PROJECT) === dialog.projectUid) {
            return;
        }

        if (!jobSelector.isValidSelectDomStruture(selectEl)) {
            console.info("Could not cause select to show all items. It does not follow the specified structure", selectEl);
            return;
        }
        selectList.items.getAll().forEach(function(item) {item.show();});
    }

    jobSelector.init = function() {
        var selectEl = $('#smartling-job-select').get(0);
        if (!selectEl || selectEl.getAttribute(ATTR_FILTER_READY_FOR_PROJECT) === dialog.projectUid) {
            return;
        }

        if (!jobSelector.isValidSelectDomStruture(selectEl)) {
            console.info("Could not add select filter to the following coral select element. It does not follow the specified structure", selectEl);
            return;
        }

        selectEl.setAttribute(ATTR_FILTER_READY_FOR_PROJECT, dialog.projectUid);

        var filter = jobSelector.newFilterTextField();
        var overlay = selectEl.querySelector("coral-overlay");
        var selectList = overlay.querySelector("coral-selectlist");

        selectEl.items.clear();
        selectList.items.clear();
        $(selectList).find('.' + SMARTLING_TOUCH_UI_SELECT_JOB_FILTER).remove();
        selectList.items.add(filter, selectList.items.first());

        filter.addEventListener("keyup", function() {
            var filterValue = filter.value;
            jobSelector.filterSelectList(selectList, filterValue);
        });

        $('#smartling-job-select coral-overlay').on('coral-overlay:open', function (e) {
            var selectList = $('#smartling-job-select coral-selectlist').get(0);
            if (selectList.items.length) {
                jobSelector.showAllItems(selectList);
                filter.value = '';
            }
        });
    }

    $(document).on("foundation-contentloaded", function(e) {
        jobSelector.init();

        $(window).adaptTo("foundation-registry").register("foundation.validation.validator", {
            selector: '#smartling-job-select',
            validate: function(e) {
                var localeElement = $(e);
                return localeElement.val() || !e.hasAttribute('smartling-custom-validation-allowed') ? '' : Granite.I18n.get("Please select Smartling Job");
            }
        });

        $('button#smartling-job-dialog-submit')
            .focusin(function(e){
                if (e.target.getAttribute('form') === 'add-to-job-form') {
                    $('#smartling-job-select').attr('smartling-custom-validation-allowed', true);
                }
            }).focusout(function(e){
            if (e.target.getAttribute('form') === 'add-to-job-form') {
                $('#smartling-job-select').removeAttr('smartling-custom-validation-allowed');
            }
        });
    });
})(jQuery(document), Granite.$);
