/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.context.impl.connection.ResourceLoadingHandlerImpl;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.core.FileUriResolver;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/context/info"})
public class ContextInfoServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextInfoServlet.class);
    private static final Gson GSON = new GsonBuilder().create();
    public static final String FILE_URI_PARAM_NAME = "fileUri";
    public static final String FROM_SOURCE_PARAM_NAME = "takePreviewFromSource";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    @Reference
    private FileUriResolver fileUriResolver;
    @Reference
    private ResourceLoader resourcesFacade;
    @Reference
    private ServletUtils servletUtils;

    public void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws IOException {
        String fileUri = ContextInfoServlet.getMandatoryParameter(request, FILE_URI_PARAM_NAME, "Missed mandatory parameter \"fileUri\".");
        boolean fromSource = request.getParameter(FROM_SOURCE_PARAM_NAME) != null ? StringUtils.equalsIgnoreCase((CharSequence)request.getParameter(FROM_SOURCE_PARAM_NAME), (CharSequence)"true") : this.resourcesFacade.takePreviewFromSource();
        try {
            String path = this.fileUriResolver.getPathByFileUri(fileUri, fromSource);
            if (!ContextInfoServlet.isContentPath(path)) {
                throw new SmartlingException("Context path=\"" + path + "\" doesn't seem proper for fileUri=\"" + fileUri + "\"");
            }
            ResourceLoadingHandlerImpl loadingHandler = new ResourceLoadingHandlerImpl(this.resourcesFacade, this.fileUriResolver);
            String basePath = loadingHandler.buildTailedPath(path);
            ContextInfoServlet.writeJson(response, new ContextInfo(fileUri, basePath));
        }
        catch (Exception e) {
            String errorMessage = "Failed to load resource for fileUri=\"" + fileUri + "\".";
            LOGGER.error(errorMessage, (Object)fileUri, (Object)e);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, errorMessage + " " + e.getMessage());
        }
    }

    private static String getMandatoryParameter(@Nonnull SlingHttpServletRequest request, String name, String errorMessage) {
        String value = request.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static boolean isContentPath(String path) {
        return StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER);
    }

    protected static void writeJson(@Nonnull SlingHttpServletResponse response, @Nonnull Object data) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        GSON.toJson(data, (Appendable)response.getWriter());
    }

    protected void bindFileUriResolver(FileUriResolver fileUriResolver) {
        this.fileUriResolver = fileUriResolver;
    }

    protected void unbindFileUriResolver(FileUriResolver fileUriResolver) {
        if (this.fileUriResolver == fileUriResolver) {
            this.fileUriResolver = null;
        }
    }

    protected void bindResourcesFacade(ResourceLoader resourceLoader) {
        this.resourcesFacade = resourceLoader;
    }

    protected void unbindResourcesFacade(ResourceLoader resourceLoader) {
        if (this.resourcesFacade == resourceLoader) {
            this.resourcesFacade = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    static class ContextInfo {
        private String fileUri;
        private String relativePath;

        public ContextInfo(String fileUri, String relativePath) {
            this.fileUri = fileUri;
            this.relativePath = relativePath;
        }
    }
}

