/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection.config;

import com.smartling.aem.connector.context.impl.ContextLockSettings;
import com.smartling.aem.connector.context.impl.connection.config.ContextLockService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SmartlingLockerTest.class})
public class SmartlingLockerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingLockerTest.class);
    private static final int EXPIRATION_PERIOD_SECONDS = 30;
    private static final int KEEP_ALIVE_PERIOD_SECONDS = 10;
    @Reference
    private ContextLockService contextLockService;
    private ExecutorService threadPool;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.threadPool = Executors.newFixedThreadPool(20);
    }

    @Deactivate
    public void deactivate() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to shutdown thread pool for pseudo translation delivery actions", (Throwable)e);
        }
    }

    public void start() {
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            ConfigLock configLock = new ConfigLock(30, 10, "name" + i, "7fe4ba2e4");
            CaptureData captureData = new CaptureData(this.contextLockService, configLock);
            futures.add(this.threadPool.submit(new CalculationJob(captureData)));
        }
        for (Future future : futures) {
            try {
                future.get(130L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                LOGGER.error("Interrupted hanging threads.", (Throwable)ex);
                future.cancel(true);
            }
        }
    }

    protected void bindContextLockService(ContextLockService contextLockService) {
        this.contextLockService = contextLockService;
    }

    protected void unbindContextLockService(ContextLockService contextLockService) {
        if (this.contextLockService == contextLockService) {
            this.contextLockService = null;
        }
    }

    class ConfigLock
    implements ContextLockSettings {
        private final int expirationPeriodInSeconds;
        private final int keepAlivePeriodInSeconds;
        private final String ownerName;
        private final String projectUid;

        public ConfigLock(int expirationPeriodInSeconds, int keepAlivePeriodInSeconds, String ownerName, String projectUid) {
            this.expirationPeriodInSeconds = expirationPeriodInSeconds;
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
            this.ownerName = ownerName;
            this.projectUid = projectUid;
        }

        @Override
        public int getExpirationPeriodInSeconds() {
            return this.expirationPeriodInSeconds;
        }

        @Override
        public int getKeepAlivePeriodInSeconds() {
            return this.keepAlivePeriodInSeconds;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public String getProjectUid() {
            return this.projectUid;
        }
    }

    class CalculationJob
    implements Runnable {
        CaptureData data;

        public CalculationJob(CaptureData data) {
            this.data = data;
        }

        @Override
        public void run() {
            Calendar endDate = Calendar.getInstance();
            endDate.add(13, 120);
            Random rand = new Random(endDate.getTimeInMillis());
            while (true) {
                boolean removeChance;
                boolean captureChance = rand.nextInt(10) < 2;
                boolean keepChance = rand.nextInt(10) < 8;
                boolean bl = removeChance = rand.nextInt(10) < 1;
                if (endDate.compareTo(Calendar.getInstance()) < 0) break;
                if (!this.data.isCaptured && captureChance) {
                    this.data.isCaptured = SmartlingLockerTest.this.contextLockService.tryLock(this.data.config);
                    LOGGER.info("User \"{}\" " + (this.data.isCaptured ? "took" : "failed to take") + " ownership.", (Object)this.data.config.getOwnerName());
                    continue;
                }
                if (this.data.isCaptured && keepChance) {
                    this.data.isCaptured = SmartlingLockerTest.this.contextLockService.renewLock(this.data.config);
                    LOGGER.info("User \"{}\" " + (this.data.isCaptured ? "keeps" : "lost") + " ownership.", (Object)this.data.config.getOwnerName());
                    continue;
                }
                if (this.data.isCaptured && removeChance) {
                    this.data.isCaptured = !SmartlingLockerTest.this.contextLockService.unlock(this.data.config);
                    LOGGER.info("User \"{}\" " + (this.data.isCaptured ? "failed to leave" : "left") + " ownership.", (Object)this.data.config.getOwnerName());
                }
                try {
                    Thread.sleep(rand.nextInt(10) * 100 + 100);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Error on sleeping");
                    break;
                }
            }
        }
    }

    class CaptureData {
        public final ContextLockSettings config;
        public ContextLockService locker;
        public boolean isCaptured;

        public CaptureData(ContextLockService locker, ContextLockSettings config) {
            this.locker = locker;
            this.config = config;
        }
    }
}

