/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection.config;

import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/context/locker/reset"})
public class ResetContextLockServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetContextLockServlet.class);
    @Reference
    private ServletUtils servletUtils;

    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String projectUid = null;
        try {
            projectUid = ResetContextLockServlet.getMandatoryParameter((SlingHttpServletRequest)request, (String)"projectUid", (String)"Mandatory projectUid parameter is missing");
            Resource lockResource = resourceResolver.getResource("/var/smartling-connector/contextLock/" + projectUid);
            if (lockResource == null) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 404, "Lock node \"" + projectUid + "\" is missing.");
                return;
            }
            resourceResolver.delete(lockResource);
            resourceResolver.commit();
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to remove lock node \"{}\":", (Object)projectUid, (Object)e);
            throw new ServletException((Throwable)e);
        }
    }
}

