/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@SlingServlet(paths={"/services/smartling/context/connection/resource/load"})
public class ResourceLoadingServlet
extends SlingSafeMethodsServlet {
    @Reference
    private ResourceLoader resourceLoader;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        String resourcePath = request.getParameter("path");
        try {
            ResourceStream stream = this.resourceLoader.loadResource(resourcePath);
            response.setContentType(stream.getContentType());
            response.setCharacterEncoding(stream.getEncoding());
            IOUtils.copy((InputStream)stream.getContentStream(), (OutputStream)response.getOutputStream());
        }
        catch (ResourceLoadingException e) {
            response.getWriter().println(e.getMessage());
            response.setStatus(500);
        }
    }

    protected void bindResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void unbindResourceLoader(ResourceLoader resourceLoader) {
        if (this.resourceLoader == resourceLoader) {
            this.resourceLoader = null;
        }
    }
}

