/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl;

import ch.qos.logback.core.util.ContextUtil;
import com.day.cq.wcm.api.WCMMode;
import com.smartling.aem.connector.context.ContextConnection;
import com.smartling.aem.connector.context.ContextConnectionManager;
import com.smartling.aem.connector.context.impl.ConnectionSettings;
import com.smartling.aem.connector.context.impl.ContextLockSettings;
import com.smartling.aem.connector.context.impl.connection.GatewayConnectionFactory;
import com.smartling.aem.connector.core.ConfigurationManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.cms.gateway.client.CmsGatewayClientException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(label="Smartling - Context Connection Manager (Touch)", immediate=true, metatype=true, description="Establishes and controls connections to Smartling to support context.")
public class ContextGateway
implements ContextConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextGateway.class);
    static final String WCM_REQUEST_FILTER_PID = "com.day.cq.wcm.core.WCMRequestFilter";
    static final String WCM_MODE_PROPERTY = "wcmfilter.mode";
    static final String COMPONENT_TITLE = "Smartling - Context Connection Manager (Touch)";
    public static final String RECONNECT_SCHEDULER_JOB_NAME = "reconnect.context.connections";
    public static final String HEARTBEAT_SCHEDULER_JOB_NAME = "heartbeat.context.connections";
    private static final boolean ENABLED_DEFAULT_VALUE = true;
    @Property(label="Enabled", description="Enables / Disables the feature", boolValue={true})
    private static final String ENABLED_PROP = "enabled";
    public static final int RECONNECT_PERIOD_IN_SECONDS_DEFAULT_VALUE = 1800;
    @Property(label="Reconnect period", description="Reconnect period in seconds", intValue={1800})
    private static final String RECONNECT_PERIOD_PROP = "reconnect.period";
    public static final int RECONNECT_AFTER_MINUTES = 5;
    public static final int CONTEXT_CONNECTION_TIMESTAMP_EXPIRATION_PERIOD_SECONDS = 60;
    public static final int CONTEXT_CONNECTION_TIMESTAMP_KEEP_ALIVE_PERIOD_SECONDS = 20;
    @Reference
    private GatewayConnectionFactory connectionFactory;
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ConfigurationAdmin configAdmin;
    private boolean enabled;
    private final ConcurrentMap<String, ContextConnection> connections = new ConcurrentHashMap<String, ContextConnection>();
    private final Runnable configurationListener = new ReconnectOnConfigChangeListener();
    private final Runnable reconnectAllJob = new ReconnectAllJob();
    private final Runnable heartbeatAllJobs = new HeartbeatAllJob();

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.enabled = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_PROP), (boolean)true);
        int reconnectPeriod = PropertiesUtil.toInteger((Object)properties.get(RECONNECT_PERIOD_PROP), (int)1800);
        boolean isAuthorMode = this.detectAuthorMode();
        if (!isAuthorMode) {
            LOGGER.error("AEM runs in non-author mode. Context supports Author mode only.");
            this.enabled = false;
            return;
        }
        if (this.enabled) {
            this.configurationManager.addListener(this.configurationListener);
            LOGGER.debug("Registered listener on configuration changes");
            LOGGER.info("Context is enabled and will be initialized on demand");
            Date afterDate = DateUtils.addMinutes((Date)new Date(), (int)5);
            LOGGER.debug("Setup scheduler for periodic context reconnection");
            ScheduleOptions scheduleOptions = this.scheduler.AT(afterDate, -1, (long)reconnectPeriod);
            scheduleOptions.name(RECONNECT_SCHEDULER_JOB_NAME);
            this.scheduler.schedule((Object)this.reconnectAllJob, scheduleOptions);
            LOGGER.debug("Setup scheduler for periodic context heartbeat");
            ScheduleOptions options = this.scheduler.AT(afterDate, -1, 20L);
            options.name(HEARTBEAT_SCHEDULER_JOB_NAME);
            this.scheduler.schedule((Object)this.heartbeatAllJobs, options);
        } else {
            LOGGER.info("Context is disabled for this instance");
        }
    }

    @Deactivate
    protected void deactivate() {
        this.scheduler.unschedule(HEARTBEAT_SCHEDULER_JOB_NAME);
        LOGGER.debug("Heartbeat schedule job is removed");
        this.scheduler.unschedule(RECONNECT_SCHEDULER_JOB_NAME);
        LOGGER.debug("Reconnection schedule job is removed");
        this.configurationManager.removeListener(this.configurationListener);
        LOGGER.debug("Unregistered Site Config listener.");
        this.releaseConnections();
    }

    @Override
    public Future<Boolean> initializeContext() {
        if (this.enabled) {
            return this.startConnectionsAsync();
        }
        LOGGER.info("Context is disabled for this instance. Use '{}' in the Felix OSGi console to turn it on", (Object)COMPONENT_TITLE);
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public Future<Boolean> initializeContextForConfig(SmartlingCloudConfig config) {
        if (config == null) {
            LOGGER.info("Config is absent. Context cannot be initialized");
            return CompletableFuture.completedFuture(false);
        }
        if (this.enabled) {
            return this.startConnectionsAsync(config);
        }
        LOGGER.info("Context is disabled for this instance. Use '{}' in the Felix OSGi console to turn it on", (Object)COMPONENT_TITLE);
        return CompletableFuture.completedFuture(false);
    }

    void setEnabled() {
        this.enabled = true;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private boolean initializeConnections() {
        LOGGER.trace("Opening context connection for all projects");
        Set<SmartlingCredentials> configsUniqueByProjectId = this.getConfigurationsUniqueByProjectId();
        for (SmartlingCredentials config : configsUniqueByProjectId) {
            if (this.initializeConnection(config)) continue;
            return false;
        }
        return true;
    }

    private boolean initializeConnection(SmartlingCredentials config) {
        ContextConnection connection;
        if (this.connections.containsKey(config.getProjectId())) {
            connection = (ContextConnection)this.connections.get(config.getProjectId());
        } else {
            ContextLockConnectionConfig captureConnectionConfig = new ContextLockConnectionConfig(60, 20, this.getHostName(), config.getProjectId());
            connection = this.connectionFactory.createConnection(new ConfigConnectionSettings(config), captureConnectionConfig);
            this.connections.put(config.getProjectId(), connection);
        }
        try {
            LOGGER.trace("Opening context connection for projectId\"{}\"", (Object)config.getProjectId());
            connection.connect();
        }
        catch (CmsGatewayClientException e) {
            LOGGER.error("Failed to open connection:", (Throwable)e);
            this.connections.remove(config.getProjectId());
            ContextGateway.silentDisconnect(connection);
            return false;
        }
        return true;
    }

    private boolean heartbeatConnection(SmartlingCredentials config) {
        if (!this.connections.containsKey(config.getProjectId())) {
            return false;
        }
        ((ContextConnection)this.connections.get(config.getProjectId())).heartbeat();
        return true;
    }

    private static void silentDisconnect(ContextConnection connection) {
        try {
            connection.disconnect();
        }
        catch (IOException e) {
            LOGGER.error("Failed to disconnect connection:", (Throwable)e);
        }
    }

    private Set<SmartlingCredentials> getConfigurationsUniqueByProjectId() {
        Collection configurations = this.configurationManager.getConfigurations();
        TreeSet<SmartlingCredentials> configsUniqueByProjectId = new TreeSet<SmartlingCredentials>(new Comparator<SmartlingCredentials>(){

            @Override
            public int compare(SmartlingCredentials config1, SmartlingCredentials config2) {
                return config1.getProjectId().compareTo(config2.getProjectId());
            }
        });
        configsUniqueByProjectId.addAll(configurations);
        return configsUniqueByProjectId;
    }

    private Future<Boolean> startConnectionsAsync() {
        Set<SmartlingCredentials> credentials = this.getConfigurationsUniqueByProjectId();
        List<CompletableFuture> resultList = credentials.stream().map(credential -> CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)credential))).collect(Collectors.toList());
        return CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).thenApply(Void2 -> resultList.stream().allMatch(this::getResultSafely));
    }

    private Future<Boolean> heartbeatConnectionsAsync() {
        Set<SmartlingCredentials> credentials = this.getConfigurationsUniqueByProjectId();
        List<CompletableFuture> resultList = credentials.stream().map(credential -> CompletableFuture.supplyAsync(() -> this.heartbeatConnection((SmartlingCredentials)credential))).collect(Collectors.toList());
        return CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).thenApply(Void2 -> resultList.stream().allMatch(this::getResultSafely));
    }

    private boolean getResultSafely(CompletableFuture<Boolean> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Couldn't open context connection", (Throwable)e);
            return false;
        }
    }

    private Future<Boolean> startConnectionsAsync(SmartlingCloudConfig config) {
        CompletableFuture<Boolean> firstResult = CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)config));
        List childCredentials = config.getLocaleProjectConfigs();
        if (childCredentials.isEmpty()) {
            return firstResult;
        }
        List<CompletableFuture> resultList = childCredentials.stream().map(credential -> CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)credential))).collect(Collectors.toList());
        resultList.add(firstResult);
        return CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).thenApply(Void2 -> resultList.stream().allMatch(this::getResultSafely));
    }

    private void releaseConnections() {
        for (ContextConnection connection : this.connections.values()) {
            LOGGER.info("Closing connection for projectId=\"{}\".", (Object)connection.getProjectId());
            try {
                connection.disconnect();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close connection for projectId=\"{}\".", (Object)connection.getProjectId(), (Object)e);
            }
        }
        this.connections.clear();
    }

    private boolean detectAuthorMode() {
        try {
            Object defaultWcmMode;
            Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=com.day.cq.wcm.core.WCMRequestFilter)");
            if (configs != null && configs.length > 0 && (defaultWcmMode = configs[0].getProperties().get(WCM_MODE_PROPERTY)) instanceof String) {
                return !StringUtils.equalsIgnoreCase((CharSequence)WCMMode.DISABLED.name(), (CharSequence)((String)defaultWcmMode));
            }
        }
        catch (IOException | InvalidSyntaxException ex) {
            LOGGER.warn("Unable to read OSGi configuration: \"{}\".", (Object)WCM_REQUEST_FILTER_PID, (Object)ex);
        }
        return false;
    }

    private String getHostName() {
        try {
            return ContextUtil.getLocalHostName();
        }
        catch (SecurityException | SocketException | UnknownHostException e) {
            return "unknown" + this.hashCode();
        }
    }

    protected void bindConnectionFactory(GatewayConnectionFactory gatewayConnectionFactory) {
        this.connectionFactory = gatewayConnectionFactory;
    }

    protected void unbindConnectionFactory(GatewayConnectionFactory gatewayConnectionFactory) {
        if (this.connectionFactory == gatewayConnectionFactory) {
            this.connectionFactory = null;
        }
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }

    static final class ContextLockConnectionConfig
    implements ContextLockSettings {
        private final int expirationPeriodInSeconds;
        private final int keepAlivePeriodInSeconds;
        private final String projectUid;
        private final String ownerName;

        public ContextLockConnectionConfig(int expirationPeriodInSeconds, int keepAlivePeriodInSeconds, String ownerName, String projectUid) {
            this.expirationPeriodInSeconds = expirationPeriodInSeconds;
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
            this.ownerName = ownerName;
            this.projectUid = projectUid;
        }

        @Override
        public int getExpirationPeriodInSeconds() {
            return this.expirationPeriodInSeconds;
        }

        @Override
        public int getKeepAlivePeriodInSeconds() {
            return this.keepAlivePeriodInSeconds;
        }

        @Override
        public String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public String getProjectUid() {
            return this.projectUid;
        }
    }

    static final class ConfigConnectionSettings
    implements ConnectionSettings {
        private final SmartlingCredentials config;

        ConfigConnectionSettings(SmartlingCredentials config) {
            this.config = config;
        }

        @Override
        public String getProjectId() {
            return this.config.getProjectId();
        }

        @Override
        public String getUserIdentifier() {
            return this.config.getUserIdentifier();
        }

        @Override
        public String getTokenSecret() {
            return this.config.getTokenSecret();
        }
    }

    private final class HeartbeatAllJob
    implements Runnable {
        private HeartbeatAllJob() {
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Making heartbeat for all configs.");
                ContextGateway.this.heartbeatConnectionsAsync().get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error("Couldn't heartbeat all contexts.", (Throwable)e);
            }
        }
    }

    private final class ReconnectAllJob
    implements Runnable {
        private ReconnectAllJob() {
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Making connections for all configs");
                ContextGateway.this.startConnectionsAsync().get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error("Couldn't reconnect all contexts", (Throwable)e);
            }
        }
    }

    private final class ReconnectOnConfigChangeListener
    implements Runnable {
        private ReconnectOnConfigChangeListener() {
        }

        @Override
        public void run() {
            try {
                if (ContextGateway.this.connections.isEmpty()) {
                    LOGGER.debug("Smartling connector configurations have been changed, but there's no connections to refresh");
                } else {
                    LOGGER.info("Smartling connector configurations have been changed. Triggering connections refresh...");
                    ContextGateway.this.releaseConnections();
                    ContextGateway.this.startConnectionsAsync().get(5L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error("Couldn't reconnect on config changes", (Throwable)e);
            }
        }
    }

    private final class StartConnectionsTask
    implements Callable<Boolean> {
        private final SmartlingCredentials config;

        StartConnectionsTask(SmartlingCredentials config) {
            this.config = config;
        }

        @Override
        public Boolean call() {
            return this.config == null ? ContextGateway.this.initializeConnections() : ContextGateway.this.initializeConnection(this.config);
        }
    }
}

