/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.sync;

import com.adobe.granite.translation.api.TranslationConstants;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.sync.JobInfo;
import com.smartling.aem.connector.core.impl.integration.sync.SyncJobInfoProvider;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationException;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationInvoker;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={SyncTranslationJobHandler.class})
@Component
public class SyncTranslationJobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTranslationJobHandler.class);
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SyncJobInfoProvider syncJobInfoProvider;
    @Reference
    private SyncTranslationInvoker syncTranslationInvoker;
    private Cache<String, JobInfo> jobRequestTracking;
    private Queue<String> jobQueue = new ConcurrentLinkedQueue<String>();
    private ExecutorService threadPool;
    private CompletableFuture<Void> syncFuture;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.jobRequestTracking = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    @Deactivate
    public void deactivate() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to shutdown thread pool for pseudo translation delivery actions", (Throwable)e);
        }
    }

    public synchronized void syncTranslationObject(String translationObjectID) throws SmartlingException {
        LOGGER.debug("Sync translation for fileURI=\"{}\"", (Object)translationObjectID);
        if (StringUtils.isBlank((CharSequence)translationObjectID)) {
            LOGGER.error("Couldn't sync translation job for empty translationObjectID.");
            throw new SyncTranslationException("Couldn't sync translation job for empty translationObjectID.");
        }
        String[] segments = StringUtils.split((String)translationObjectID, (String)":");
        if (segments.length != 2) {
            String message = String.format("Couldn't sync translation job, translationObjectID=\"%s\" has unknown format.", translationObjectID);
            LOGGER.error(message);
            throw new SyncTranslationException(message);
        }
        String translationJobId = segments[0];
        this.jobQueue.add(translationJobId);
        if (this.syncFuture == null || this.syncFuture.isDone()) {
            this.syncFuture = CompletableFuture.runAsync(this::startSyncJob, this.threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSyncJob() {
        int preventInfinite = 10000;
        while (!this.jobQueue.isEmpty() && preventInfinite-- > 0) {
            HashSet<String> pendingJobs = new HashSet<String>();
            while (!this.jobQueue.isEmpty()) {
                String translationJobId = this.jobQueue.poll();
                if (this.jobRequestTracking.getIfPresent((Object)translationJobId) != null) {
                    pendingJobs.add(translationJobId);
                    continue;
                }
                ResourceResolver resourceResolver = null;
                try {
                    resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
                    JobInfo job = this.syncJobInfoProvider.getJobInfo(resourceResolver, translationJobId);
                    if (job.getStatus() == TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION || job.getStatus() == TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS || job.getStatus() == TranslationConstants.TranslationStatus.SUBMITTED) {
                        this.syncTranslationInvoker.syncTranslationJobByPath(resourceResolver, job.getResourcePath());
                    }
                    this.jobRequestTracking.put((Object)translationJobId, (Object)job);
                }
                catch (LoginException e) {
                    LOGGER.error("Failed to get repository session for translation job id=\"{}\"", (Object)translationJobId, (Object)e);
                }
                catch (SyncTranslationException e) {
                    LOGGER.error("Failed sync translation job id=\"{}\"", (Object)translationJobId, (Object)e);
                }
                finally {
                    if (resourceResolver == null || !resourceResolver.isLive()) continue;
                    resourceResolver.close();
                }
            }
            if (pendingJobs.isEmpty()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Couldn't wait for pending translation jobs", (Throwable)e);
                return;
            }
            this.jobQueue.addAll(pendingJobs);
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindSyncJobInfoProvider(SyncJobInfoProvider syncJobInfoProvider) {
        this.syncJobInfoProvider = syncJobInfoProvider;
    }

    protected void unbindSyncJobInfoProvider(SyncJobInfoProvider syncJobInfoProvider) {
        if (this.syncJobInfoProvider == syncJobInfoProvider) {
            this.syncJobInfoProvider = null;
        }
    }

    protected void bindSyncTranslationInvoker(SyncTranslationInvoker syncTranslationInvoker) {
        this.syncTranslationInvoker = syncTranslationInvoker;
    }

    protected void unbindSyncTranslationInvoker(SyncTranslationInvoker syncTranslationInvoker) {
        if (this.syncTranslationInvoker == syncTranslationInvoker) {
            this.syncTranslationInvoker = null;
        }
    }
}

