/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.auditlog;

import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.impl.integration.platform.AuditLogClient;
import com.smartling.aem.connector.core.impl.integration.platform.AuditLogClientFactory;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Service(value={AuditLogClientFacade.class})
@Component
public class AuditLogClientFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogClientFacade.class);
    private ExecutorService threadPool;
    @Reference
    private AuditLogClientFactory auditLogClientFactory;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.threadPool = Executors.newCachedThreadPool();
    }

    @Deactivate
    public void deactivate() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to shutdown thread pool for pseudo translation delivery actions", (Throwable)e);
        }
    }

    public void logStartSmartlingWorkflow(SmartlingConfig config, TranslationRequest translationRequest) {
        Map threadContext = MDC.getCopyOfContextMap();
        this.threadPool.submit(() -> {
            try {
                if (threadContext != null) {
                    MDC.setContextMap((Map)threadContext);
                }
                AuditLogClient auditLogClient = this.auditLogClientFactory.createClient(config);
                auditLogClient.logStartSmartlingWorkflow(translationRequest);
            }
            catch (Exception ex) {
                LOGGER.error("Couldn't log into Audit log", (Throwable)ex);
            }
            finally {
                MDC.clear();
            }
        });
    }

    protected void bindAuditLogClientFactory(AuditLogClientFactory auditLogClientFactory) {
        this.auditLogClientFactory = auditLogClientFactory;
    }

    protected void unbindAuditLogClientFactory(AuditLogClientFactory auditLogClientFactory) {
        if (this.auditLogClientFactory == auditLogClientFactory) {
            this.auditLogClientFactory = null;
        }
    }
}

