/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={JsonAutoDetectStringProcessor.class})
@Component(label="Smartling - Parse JSON strings (Touch)", description="Ingest JSON as translatable content", immediate=true, metatype=true)
public class JsonAutoDetectStringProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonAutoDetectStringProcessor.class);
    private static final boolean ENABLED_DEFAULT_VALUE = false;
    @Property(label="Enables JSON auto detect", description="This will add additional smartling directives in order to enable JSON auto detect in AEM page properties", boolValue={false})
    private static final String ENABLED_UNESCAPING = "enabled";
    @Property(label="JSON translatable fields", description="Only these JSON fields will be ingested as content", unbounded=PropertyUnbounded.ARRAY)
    private static final String TRANSLATABLE_FIELDS = "translatableFields";
    private Map<String, String> autoDetectStringFormatJsonDirectives = Collections.emptyMap();
    private String translatePathsDirectiveValue = "";
    private boolean enabledUnescaping;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.enabledUnescaping = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_UNESCAPING), (boolean)false);
        if (this.enabledUnescaping) {
            LOGGER.info("Unescaping html in json properties is enabled");
            String[] fields = PropertiesUtil.toStringArray((Object)properties.get(TRANSLATABLE_FIELDS), (String[])new String[0]);
            Set fieldsWithJson = Arrays.stream(fields).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            this.autoDetectStringFormatJsonDirectives = Collections.singletonMap("smartling.auto_detect_string_format", "json");
            this.translatePathsDirectiveValue = String.join((CharSequence)", ", fieldsWithJson);
        }
    }

    public Map<String, String> getAutoDetectStringJsonFormatDirectives() {
        return this.autoDetectStringFormatJsonDirectives;
    }

    public String getTranslatePathsDirectiveValue() {
        return this.translatePathsDirectiveValue;
    }
}

