/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.adobe.granite.taskmanagement.Task;
import com.adobe.granite.taskmanagement.TaskAction;
import com.adobe.granite.taskmanagement.TaskManager;
import com.adobe.granite.taskmanagement.TaskManagerFactory;
import com.smartling.aem.connector.core.impl.integration.platform.InboxNotificationService;
import java.util.Collections;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class InboxNotificationServiceImpl
implements InboxNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboxNotificationServiceImpl.class);
    private static final String NOTIFICATION_TASK_TYPE = "Notification";
    private static final String TASK_ACTION = "Approve";
    private static final String CURRENT_ASSIGNEE = "workflow-process-service";

    @Override
    public void sendNotification(ResourceResolver resourceResolver, String title, String message, String contentPath) {
        LOGGER.info(title + ". " + message + ". Source path: " + contentPath);
        try {
            TaskManager taskManager = (TaskManager)resourceResolver.adaptTo(TaskManager.class);
            TaskManagerFactory taskManagerFactory = taskManager.getTaskManagerFactory();
            Task newTask = taskManagerFactory.newTask(NOTIFICATION_TASK_TYPE);
            newTask.setName(title);
            TaskAction newTaskAction = taskManager.getTaskManagerFactory().newTaskAction(TASK_ACTION);
            newTask.setActions(Collections.singletonList(newTaskAction));
            newTask.setContentPath(contentPath);
            newTask.setCurrentAssignee(CURRENT_ASSIGNEE);
            newTask.setDescription(message);
            taskManager.createTask(newTask);
        }
        catch (Exception e) {
            LOGGER.error("Unable to send Task notificaiton {}", (Throwable)e);
        }
    }
}

