/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.config.CallbackUriProviderConfig;
import com.smartling.aem.connector.core.impl.config.StringDuplicatesProcessor;
import com.smartling.aem.connector.core.impl.config.TranslatableContentConfigurationsService;
import com.smartling.aem.connector.core.impl.integration.ResourceNamespaceResolver;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadRequest;
import com.smartling.aem.connector.core.impl.integration.platform.FileUploadConfigurer;
import com.smartling.aem.connector.core.impl.integration.platform.JsonAutoDetectStringProcessor;
import com.smartling.aem.connector.core.impl.integration.platform.SmartlingSupport;
import com.smartling.api.files.v2.pto.FileType;
import com.smartling.api.jobbatches.v1.pto.FileUploadPTO;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileUploadConfigurerImpl
implements FileUploadConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadConfigurerImpl.class);
    static final String TRANSLATE_PATH_DIRECTIVE = "smartling.translate_paths";
    static final String CUSTOM_PLACEHOLDER_FORMAT_DIRECTIVE = "smartling.placeholder_format_custom";
    private static final String SMARTLING_NAMESPACE = "smartling.namespace";
    private static final Map<String, String> PARSER_DIRECTIVES = new TreeMap<String, String>(){
        {
            this.put(FileUploadConfigurerImpl.TRANSLATE_PATH_DIRECTIVE, String.join((CharSequence)",", "translationObjectFile/translationObjectProperties/property-html", "translationObjectFile/translationObjectProperties/property-text", "translationObjectFile/translationObjectProperties/property-markdown"));
            this.put("smartling.string_format_paths", String.format("html: %s, txt: %s, markdown: %s", "translationObjectFile/translationObjectProperties/property-html", "translationObjectFile/translationObjectProperties/property-text", "translationObjectFile/translationObjectProperties/property-markdown"));
        }
    };
    private final StringDuplicatesProcessor stringDuplicatesProcessor;
    private final JsonAutoDetectStringProcessor jsonAutoDetectStringProcessor;
    private final ResourceNamespaceResolver resourceNamespaceResolver;
    private final CallbackUriProviderConfig callbackUriProviderConfig;
    private final TranslatableContentConfigurationsService translatableContentConfigurationsService;

    FileUploadConfigurerImpl(StringDuplicatesProcessor stringDuplicatesProcessor, JsonAutoDetectStringProcessor jsonAutoDetectStringProcessor, ResourceNamespaceResolver resourceNamespaceResolver, CallbackUriProviderConfig callbackUriProviderConfig, TranslatableContentConfigurationsService translatableContentConfigurationsService) {
        this.stringDuplicatesProcessor = Objects.requireNonNull(stringDuplicatesProcessor);
        this.jsonAutoDetectStringProcessor = Objects.requireNonNull(jsonAutoDetectStringProcessor);
        this.resourceNamespaceResolver = Objects.requireNonNull(resourceNamespaceResolver);
        this.callbackUriProviderConfig = Objects.requireNonNull(callbackUriProviderConfig);
        this.translatableContentConfigurationsService = Objects.requireNonNull(translatableContentConfigurationsService);
    }

    @Override
    public FileUploadPTO buildUploadParameters(TranslationUploadRequest request) throws SmartlingException {
        if (request.getResource().getType() == SmartlingFacade.Type.DITA) {
            return this.buildUploadDitaParameters(request);
        }
        if (request.getResource().getType() == SmartlingFacade.Type.ASSET) {
            return this.buildUploadAssetParameters(request);
        }
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.putAll(PARSER_DIRECTIVES);
        directives.putAll(request.getResource().getType() == SmartlingFacade.Type.I18N ? this.stringDuplicatesProcessor.getVariantsByPropertyNameDirectives() : this.stringDuplicatesProcessor.getVariantsDirectives());
        directives.putAll(this.jsonAutoDetectStringProcessor.getAutoDetectStringJsonFormatDirectives());
        directives.compute(TRANSLATE_PATH_DIRECTIVE, (k, existingValue) -> this.mergeWithComaDelimiter((String)existingValue, this.jsonAutoDetectStringProcessor.getTranslatePathsDirectiveValue()));
        directives.put(SMARTLING_NAMESPACE, this.resourceNamespaceResolver.resolveNamespace(request, this.stringDuplicatesProcessor.shouldShareStrings(), this.stringDuplicatesProcessor.shouldUseUniqueStrings()));
        directives.put(CUSTOM_PLACEHOLDER_FORMAT_DIRECTIVE, this.translatableContentConfigurationsService.getCustomPlaceholderFormatValue());
        directives.putAll(this.translatableContentConfigurationsService.getCustomDirectives());
        FileType fileType = FileUploadConfigurerImpl.fileTypeForMimeType(request.getResource().getMimeType(), request.getFileUri());
        FileUploadPTO fileUploadPTO = new FileUploadPTO();
        fileUploadPTO.setFileType(fileType.getIdentifier());
        fileUploadPTO.setFileUri(request.getFileUri());
        fileUploadPTO.setLocaleIdsToAuthorize(Collections.singletonList(request.getSmartlingTargetLocaleCode()));
        this.setCallback(fileUploadPTO, this.callbackUriProviderConfig.getCallbackUrl());
        fileUploadPTO.setFile(this.getFile(request.getResource()));
        fileUploadPTO.setDirectives(directives);
        fileUploadPTO.setMoveExistingStrings(Boolean.valueOf(request.isMoveStrings()));
        return fileUploadPTO;
    }

    private FileUploadPTO buildUploadDitaParameters(TranslationUploadRequest request) throws SmartlingException {
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("smartling.force_inline_for_tags", "a,abbr,b,cite,code,dfn,em,i,kbd,q,small,span,strong,sub,sup,time,var,xref");
        directives.putAll(this.stringDuplicatesProcessor.getVariantsDirectives());
        directives.put(SMARTLING_NAMESPACE, this.resourceNamespaceResolver.resolveNamespace(request, this.stringDuplicatesProcessor.shouldShareStrings(), this.stringDuplicatesProcessor.shouldUseUniqueStrings()));
        directives.putAll(this.translatableContentConfigurationsService.getCustomDirectives());
        FileUploadPTO fileUploadPTO = new FileUploadPTO();
        fileUploadPTO.setFileType(FileType.DITA.getIdentifier());
        fileUploadPTO.setFileUri(request.getFileUri());
        fileUploadPTO.setLocaleIdsToAuthorize(Collections.singletonList(request.getSmartlingTargetLocaleCode()));
        this.setCallback(fileUploadPTO, this.callbackUriProviderConfig.getCallbackUrl());
        fileUploadPTO.setFile(this.getFile(request.getResource()));
        fileUploadPTO.setDirectives(directives);
        fileUploadPTO.setMoveExistingStrings(Boolean.valueOf(request.isMoveStrings()));
        return fileUploadPTO;
    }

    private FileUploadPTO buildUploadAssetParameters(TranslationUploadRequest request) throws SmartlingException {
        HashMap<String, String> directives = new HashMap<String, String>(this.stringDuplicatesProcessor.getVariantsDirectives());
        directives.put(SMARTLING_NAMESPACE, this.resourceNamespaceResolver.resolveNamespace(request, this.stringDuplicatesProcessor.shouldShareStrings(), this.stringDuplicatesProcessor.shouldUseUniqueStrings()));
        directives.putAll(this.translatableContentConfigurationsService.getCustomDirectives());
        FileType fileType = FileUploadConfigurerImpl.fileTypeForMimeType(request.getResource().getMimeType(), request.getFileUri());
        FileUploadPTO fileUploadPTO = new FileUploadPTO();
        fileUploadPTO.setFileType(fileType.getIdentifier());
        fileUploadPTO.setFileUri(request.getFileUri());
        fileUploadPTO.setLocaleIdsToAuthorize(Collections.singletonList(request.getSmartlingTargetLocaleCode()));
        this.setCallback(fileUploadPTO, this.callbackUriProviderConfig.getCallbackUrl());
        fileUploadPTO.setFile(this.getFile(request.getResource()));
        fileUploadPTO.setDirectives(directives);
        fileUploadPTO.setMoveExistingStrings(Boolean.valueOf(request.isMoveStrings()));
        return fileUploadPTO;
    }

    private void setCallback(FileUploadPTO fileUploadPTO, String callbackUrl) {
        if (StringUtils.isBlank((CharSequence)callbackUrl)) {
            return;
        }
        try {
            new URL(callbackUrl).toURI();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Callback URL \"{}\" is malformed", (Object)callbackUrl, (Object)e);
            return;
        }
        catch (URISyntaxException e) {
            LOGGER.error("Callback URL \"{}\" has wrong syntax", (Object)callbackUrl, (Object)e);
            return;
        }
        fileUploadPTO.setCallbackUrl(callbackUrl);
    }

    private byte[] getFile(SmartlingFacade.Resource resource) throws SmartlingException {
        try {
            return IOUtils.toByteArray((InputStream)resource.getContentStream());
        }
        catch (IOException e) {
            throw new SmartlingException("Can not serialize translation resource", e);
        }
    }

    private String mergeWithComaDelimiter(String existingValue, String newValue) {
        if (StringUtils.isEmpty((CharSequence)existingValue) && !StringUtils.isEmpty((CharSequence)newValue)) {
            return newValue;
        }
        if (!StringUtils.isEmpty((CharSequence)existingValue) && StringUtils.isEmpty((CharSequence)newValue)) {
            return existingValue;
        }
        if (!StringUtils.isEmpty((CharSequence)existingValue) && !StringUtils.isEmpty((CharSequence)newValue)) {
            return existingValue + ", " + newValue;
        }
        return "";
    }

    private static FileType fileTypeForMimeType(String mimeType, String fileUri) {
        FileType fileType;
        FileType fileType2 = fileType = StringUtils.isNotBlank((CharSequence)mimeType) ? SmartlingSupport.FILE_TYPE_BY_MIME.get(mimeType) : null;
        if (fileType == null) {
            LOGGER.warn("There is no file type for the resource fileUri=\"{}\"", (Object)fileUri);
            return FileType.XML;
        }
        return fileType;
    }
}

