/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.impl.config.CallbackUriProviderConfig;
import com.smartling.aem.connector.core.impl.config.StringDuplicatesProcessor;
import com.smartling.aem.connector.core.impl.config.TranslatableContentConfigurationsService;
import com.smartling.aem.connector.core.impl.integration.ResourceNamespaceResolver;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.ApiV2SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.FileUploadConfigurerImpl;
import com.smartling.aem.connector.core.impl.integration.platform.JobBatchesApiAdapterFactory;
import com.smartling.aem.connector.core.impl.integration.platform.JsonAutoDetectStringProcessor;
import com.smartling.aem.connector.core.impl.integration.platform.processor.PostDownloadProcessor;
import com.smartling.aem.connector.core.impl.integration.platform.processor.ProcessorService;
import com.smartling.api.jobbatches.v1.JobBatchesApi;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Service
@Component
public class ApiV2SmartlingPlatformClientFactory
implements SmartlingPlatformClientFactory {
    @Reference
    private FileApiClientFactory fileApiClientFactory;
    @Reference
    private StringDuplicatesProcessor stringDuplicatesProcessor;
    @Reference
    private JsonAutoDetectStringProcessor jsonAutoDetectStringProcessor;
    @Reference
    private ResourceNamespaceResolver resourceNamespaceResolver;
    @Reference
    private CallbackUriProviderConfig callbackUriProviderConfig;
    @Reference
    private TranslatableContentConfigurationsService translatableContentConfigurationsService;
    @Reference
    private JobBatchesApiAdapterFactory jobsBatchesApiFactory;

    @Override
    public SmartlingPlatformClient createClient(SmartlingConfig config) {
        FileApiClient fileApiClient = this.fileApiClientFactory.createClient(config);
        JobBatchesApi jobBatchesApi = this.jobsBatchesApiFactory.createClient(config);
        FileUploadConfigurerImpl fileUploadConfigurer = new FileUploadConfigurerImpl(this.stringDuplicatesProcessor, this.jsonAutoDetectStringProcessor, this.resourceNamespaceResolver, this.callbackUriProviderConfig, this.translatableContentConfigurationsService);
        return new ApiV2SmartlingPlatformClient(fileApiClient, jobBatchesApi, fileUploadConfigurer, this.processorService());
    }

    private ProcessorService processorService() {
        return new ProcessorService(new PostDownloadProcessor[0]);
    }

    protected void bindFileApiClientFactory(FileApiClientFactory fileApiClientFactory) {
        this.fileApiClientFactory = fileApiClientFactory;
    }

    protected void unbindFileApiClientFactory(FileApiClientFactory fileApiClientFactory) {
        if (this.fileApiClientFactory == fileApiClientFactory) {
            this.fileApiClientFactory = null;
        }
    }

    protected void bindStringDuplicatesProcessor(StringDuplicatesProcessor stringDuplicatesProcessor) {
        this.stringDuplicatesProcessor = stringDuplicatesProcessor;
    }

    protected void unbindStringDuplicatesProcessor(StringDuplicatesProcessor stringDuplicatesProcessor) {
        if (this.stringDuplicatesProcessor == stringDuplicatesProcessor) {
            this.stringDuplicatesProcessor = null;
        }
    }

    protected void bindJsonAutoDetectStringProcessor(JsonAutoDetectStringProcessor jsonAutoDetectStringProcessor) {
        this.jsonAutoDetectStringProcessor = jsonAutoDetectStringProcessor;
    }

    protected void unbindJsonAutoDetectStringProcessor(JsonAutoDetectStringProcessor jsonAutoDetectStringProcessor) {
        if (this.jsonAutoDetectStringProcessor == jsonAutoDetectStringProcessor) {
            this.jsonAutoDetectStringProcessor = null;
        }
    }

    protected void bindResourceNamespaceResolver(ResourceNamespaceResolver resourceNamespaceResolver) {
        this.resourceNamespaceResolver = resourceNamespaceResolver;
    }

    protected void unbindResourceNamespaceResolver(ResourceNamespaceResolver resourceNamespaceResolver) {
        if (this.resourceNamespaceResolver == resourceNamespaceResolver) {
            this.resourceNamespaceResolver = null;
        }
    }

    protected void bindCallbackUriProviderConfig(CallbackUriProviderConfig callbackUriProviderConfig) {
        this.callbackUriProviderConfig = callbackUriProviderConfig;
    }

    protected void unbindCallbackUriProviderConfig(CallbackUriProviderConfig callbackUriProviderConfig) {
        if (this.callbackUriProviderConfig == callbackUriProviderConfig) {
            this.callbackUriProviderConfig = null;
        }
    }

    protected void bindTranslatableContentConfigurationsService(TranslatableContentConfigurationsService translatableContentConfigurationsService) {
        this.translatableContentConfigurationsService = translatableContentConfigurationsService;
    }

    protected void unbindTranslatableContentConfigurationsService(TranslatableContentConfigurationsService translatableContentConfigurationsService) {
        if (this.translatableContentConfigurationsService == translatableContentConfigurationsService) {
            this.translatableContentConfigurationsService = null;
        }
    }

    protected void bindJobsBatchesApiFactory(JobBatchesApiAdapterFactory jobBatchesApiAdapterFactory) {
        this.jobsBatchesApiFactory = jobBatchesApiAdapterFactory;
    }

    protected void unbindJobsBatchesApiFactory(JobBatchesApiAdapterFactory jobBatchesApiAdapterFactory) {
        if (this.jobsBatchesApiFactory == jobBatchesApiAdapterFactory) {
            this.jobsBatchesApiFactory = null;
        }
    }
}

