/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={StringDuplicatesProcessor.class})
@Component(label="Smartling - String Duplicates Processor (Touch)", immediate=true, metatype=true, description="Smartling allows for multiple methods of managing duplicate content across files and locales and within a single file.  Content can be shared - a single string is created across locales - or unshared - a unique string is created for every file locale.  The following options determine how content is processed when a file is uploaded to Smartling.")
public class StringDuplicatesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringDuplicatesProcessor.class);
    private static final boolean ENABLED_VARIANTS_DEFAULT_VALUE = false;
    @Property(label="Send page content with variants", description="By default page content is de-duplicated in Smartling and repeated content is treated as a single string for translation. If checked, content is uploaded to Smartling with variants enabled and repeated page content will be treated as unique for translation. Important! This configuration should be set during initial setup as changing it may result in new content for translation or loss of existing translations on a page.", boolValue={false})
    private static final String ENABLED_VARIANTS = "enabledVariants";
    private static final boolean ENABLED_LEGACY_NAMESPACES_DEFAULT_VALUE = false;
    @Property(label="Use legacy namespaces", description="By default the connector will upload the same page content for each language as unique strings. If checked, then strings will be shared across files of the same page. Important! This configuration should be set during initial setup as changing it may result in new content for translation or loss of existing translations on a page.", boolValue={false})
    private static final String ENABLED_LEGACY_NAMESPACES = "enabledLegacyNamespaces";
    private static final boolean ENABLED_UNIQUE_NAMESPACES_DEFAULT_VALUE = false;
    @Property(label="Use unique namespaces for Dam Assets, Experience and Content fragments", description="Strings will be shared across files of the same asset or fragment by default. But if checked, strings for every asset or fragment will not be shared. If checked, this option overrides using of legacy namespaces option for an asset or fragment.", boolValue={false})
    private static final String ENABLED_UNIQUE_NAMESPACES = "enabledUniqueNamespaces";
    private boolean shareStrings = false;
    private boolean useUniqueStrings = false;
    private static final Map<String, String> VARIANTS_ENABLED_DIRECTIVES = new HashMap<String, String>(){
        {
            this.put("smartling.variants_enabled", "true");
            this.put("smartling.source_key_paths", "translationObjectFile/translationObjectProperties/{property-html.nodePath},translationObjectFile/translationObjectProperties/{property-text.nodePath}");
        }
    };
    private static final Map<String, String> VARIANTS_BY_PROPERTY_NAME_ENABLED_DIRECTIVES = new HashMap<String, String>(){
        {
            this.put("smartling.variants_enabled", "true");
            this.put("smartling.source_key_paths", "translationObjectFile/translationObjectProperties/{property-html.propertyName},translationObjectFile/translationObjectProperties/{property-text.propertyName}");
        }
    };
    private Map<String, String> variants = Collections.emptyMap();
    private Map<String, String> variantsByPropertyName = Collections.emptyMap();

    @Activate
    protected void activate(Map<String, Object> properties) {
        boolean enabled = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_VARIANTS), (boolean)false);
        if (enabled) {
            this.variants = VARIANTS_ENABLED_DIRECTIVES;
            this.variantsByPropertyName = VARIANTS_BY_PROPERTY_NAME_ENABLED_DIRECTIVES;
            LOGGER.info("String variants support is enabled");
        }
        this.shareStrings = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_LEGACY_NAMESPACES), (boolean)false);
        this.useUniqueStrings = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_UNIQUE_NAMESPACES), (boolean)false);
    }

    public Map<String, String> getVariantsDirectives() {
        return this.variants;
    }

    public Map<String, String> getVariantsByPropertyNameDirectives() {
        return this.variantsByPropertyName;
    }

    public boolean shouldShareStrings() {
        return this.shareStrings;
    }

    public boolean shouldUseUniqueStrings() {
        return this.useUniqueStrings;
    }
}

