/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.smartling.aem.connector.core.NetworkSettings;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(label="Smartling - Network Settings (Touch)", description="Network configuration for Smartling Connector", metatype=true)
public class NetworkConfiguration
implements NetworkSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkConfiguration.class);
    @Property(label="Enable Proxy", description="Whether to enable or disable this particular proxy configuration. The default value is false.", boolValue={false})
    private static final String PROXY_ENABLED = "proxy.enabled";
    @Property(label="Proxy Host", description="Host name (or IP Address) of the HTTP Proxy. This property is ignored if this proxy configuration is disabled. This property does not have a default value. ")
    private static final String PROXY_HOST = "proxy.host";
    @Property(label="Proxy Port", description="TCP port of the HTTP Proxy. This property is ignored if this proxy configuration is disabled. This property does not have a default value")
    private static final String PROXY_PORT = "proxy.port";
    @Property(label="Proxy User", description="The name of the user to authenticate as with the HTTP Proxy Host. If this field is empty, the proxy is considered to not be authenticated. The default is empty.")
    private static final String PROXY_USER = "proxy.user";
    @Property(label="Proxy Password", description="The password of the HTTP Proxy user to authenticate with. The default is empty.")
    private static final String PROXY_PASSWORD = "proxy.password";
    private boolean proxyEnabled;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.proxyHost = NetworkConfiguration.getStringValueOrNull(properties.get(PROXY_HOST));
        this.proxyPort = NetworkConfiguration.toInteger(properties.get(PROXY_PORT));
        this.proxyUser = NetworkConfiguration.getStringValueOrNull(properties.get(PROXY_USER));
        this.proxyPassword = NetworkConfiguration.getStringValueOrNull(properties.get(PROXY_PASSWORD));
        boolean bl = this.proxyEnabled = PropertiesUtil.toBoolean((Object)properties.get(PROXY_ENABLED), (boolean)false) && this.proxyHost != null && this.proxyPort != null;
        if (this.proxyEnabled) {
            if (this.proxyUser == null) {
                LOGGER.info("Using anonymous proxy {}:{}", (Object)this.proxyHost, (Object)this.proxyPort);
            } else {
                LOGGER.info("Using proxy {}:{}, authenticating as {}/******", new Object[]{this.proxyHost, this.proxyPort, this.proxyUser});
            }
        } else {
            LOGGER.info("Proxy is disabled or configuration incomplete");
        }
    }

    private static String getStringValueOrNull(Object value) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtil.toString((Object)value, null), null);
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            try {
                return Integer.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Value {} is not a number. Will treat it as empty:", value, (Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean requireProxyAuthentication() {
        return this.getProxyUser() != null && this.getProxyPassword() != null;
    }
}

