/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.util.ContextUtil;
import com.smartling.aem.connector.core.NetworkSettings;
import com.smartling.connectors.appenders.logback.ExternalAppender;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ExternalLoggingConfig {
    private static final int APPENDER_BUFFER_MAX_SIZE = 50;
    private static final int APPENDER_BUFFER_TIME_THRESHOLD = 1000;
    private static final int APPENDER_QUEUE_SIZE = 1000;
    private static final String APPENDER_NAME = "ExternalLoggingAppender";
    private static final String APPENDER_CHANNEL = "aem-touch";
    private static final String APPENDER_LAYOUT_PATTERN = "[%thread] %logger{15}#%line %msg";
    private final String APPENDER_HOST = this.getHostName();
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration serviceRegistration;
    @Reference
    NetworkSettings networkSettings;

    @Activate
    private void activate(BundleContext bundleContext) {
        ExternalAppender appender = new ExternalAppender();
        appender.setName(APPENDER_NAME);
        appender.setChannel(APPENDER_CHANNEL);
        appender.setHost(this.APPENDER_HOST);
        appender.setBufferMaxSize(50);
        appender.setBufferTimeThreshold(1000);
        appender.setQueueSize(1000);
        if (this.networkSettings.isProxyEnabled()) {
            appender.setProxyHost(this.networkSettings.getProxyHost());
            appender.setProxyPort(this.networkSettings.getProxyPort());
            appender.setProxyUser(this.networkSettings.getProxyUser());
            appender.setProxyPassword(this.networkSettings.getProxyPassword());
        }
        PatternLayout layout = new PatternLayout();
        layout.setPattern(APPENDER_LAYOUT_PATTERN);
        appender.setLayout((Layout)layout);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        String[] loggers = new String[]{"com.smartling", "com.adobe.cq.wcm.translation", "com.adobe.granite.translation", "com.adobe.granite.workflow"};
        ((Dictionary)props).put("loggers", loggers);
        this.serviceRegistration = bundleContext.registerService(Appender.class.getName(), (Object)appender, props);
        this.LOGGER.info("Registering Custom logging appender - name=\"{}\", channel=\"{}\", host=\"{}\", pattern=\"{}\"", new Object[]{APPENDER_NAME, APPENDER_CHANNEL, this.APPENDER_HOST, APPENDER_LAYOUT_PATTERN});
    }

    @Deactivate
    private void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.LOGGER.info("Deregistering Custom logging appender");
        }
    }

    private String getHostName() {
        try {
            return ContextUtil.getLocalHostName();
        }
        catch (SecurityException | SocketException | UnknownHostException e) {
            return "unknown" + this.hashCode();
        }
    }

    protected void bindNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    protected void unbindNetworkSettings(NetworkSettings networkSettings) {
        if (this.networkSettings == networkSettings) {
            this.networkSettings = null;
        }
    }
}

