/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.core.TranslationCloudConfigUtil;
import com.adobe.granite.translation.core.common.AbstractTranslationServiceFactory;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingTranslationService;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationDetailsManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.BulkTranslationService;
import com.smartling.aem.connector.core.impl.DummySmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.SmartlingTranslationService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Service
@Component
@Property(name="translationFactory", value={"smartling"})
public class SmartlingTranslationServiceFactory
extends AbstractTranslationServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingTranslationServiceFactory.class);
    private static final List<TranslationConstants.TranslationMethod> METHODS = Collections.singletonList(TranslationConstants.TranslationMethod.HUMAN_TRANSLATION);
    @Reference
    private TranslationConfig translationConfig;
    @Reference
    private SmartlingFacade facade;
    @Reference
    private TranslationCloudConfigUtil translationCloudConfigUtil;
    @Reference
    private PropertyMappingTranslationService propertyMappingTranslationService;
    @Reference
    private TranslationDetailsManager translationDetailsManager;

    public TranslationService createTranslationService(TranslationConstants.TranslationMethod translationMethod, String cloudConfigPath) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationServiceFactory#createTranslationService({}, {})", (Object)translationMethod, (Object)cloudConfigPath);
        try {
            return this.getTranslationService(cloudConfigPath);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create translation service:", (Throwable)e);
            throw new TranslationException("Could not load configuration", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    private TranslationService getTranslationService(String cloudConfigPath) {
        SmartlingCloudConfig cloudConfig;
        if (cloudConfigPath != null) {
            cloudConfig = (SmartlingCloudConfig)this.translationCloudConfigUtil.getCloudConfigObjectFromPath(SmartlingCloudConfig.class, cloudConfigPath);
            if (cloudConfig == null) {
                LOGGER.warn("Couldn't find Smartling Cloud config for cloudConfigPath=\"{}\"", (Object)cloudConfigPath);
                cloudConfig = new DummySmartlingCloudConfig();
            }
        } else {
            LOGGER.debug("AEM created Smartling Translation Service with cloudConfigPath=\"{}\". Cloud config is dummy", (Object)cloudConfigPath);
            cloudConfig = new DummySmartlingCloudConfig();
        }
        SmartlingTranslationService translationService = new SmartlingTranslationService(cloudConfig, this.factoryName, "Smartling", this.translationConfig, this.facade, this.propertyMappingTranslationService, this.translationDetailsManager);
        return this.createTranslationServiceLoggingProxy(new BulkTranslationService(translationService), cloudConfig.getProjectId());
    }

    public List<TranslationConstants.TranslationMethod> getSupportedTranslationMethods() {
        LOGGER.trace("In SmartlingTranslationServiceFactory#getSupportedTranslationMethods()");
        return METHODS;
    }

    public Class<?> getServiceCloudConfigClass() {
        LOGGER.trace("In SmartlingTranslationServiceFactory#getServiceCloudConfigClass()");
        return SmartlingCloudConfig.class;
    }

    private TranslationService createTranslationServiceLoggingProxy(TranslationService translationService, String projectId) {
        Object proxy = Proxy.newProxyInstance(TranslationService.class.getClassLoader(), new Class[]{TranslationService.class}, (InvocationHandler)new LoggingContextInvocationHandler(translationService, projectId));
        return (TranslationService)proxy;
    }

    protected void bindTranslationConfig(TranslationConfig translationConfig) {
        this.translationConfig = translationConfig;
    }

    protected void unbindTranslationConfig(TranslationConfig translationConfig) {
        if (this.translationConfig == translationConfig) {
            this.translationConfig = null;
        }
    }

    protected void bindFacade(SmartlingFacade smartlingFacade) {
        this.facade = smartlingFacade;
    }

    protected void unbindFacade(SmartlingFacade smartlingFacade) {
        if (this.facade == smartlingFacade) {
            this.facade = null;
        }
    }

    protected void bindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        this.translationCloudConfigUtil = translationCloudConfigUtil;
    }

    protected void unbindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        if (this.translationCloudConfigUtil == translationCloudConfigUtil) {
            this.translationCloudConfigUtil = null;
        }
    }

    protected void bindPropertyMappingTranslationService(PropertyMappingTranslationService propertyMappingTranslationService) {
        this.propertyMappingTranslationService = propertyMappingTranslationService;
    }

    protected void unbindPropertyMappingTranslationService(PropertyMappingTranslationService propertyMappingTranslationService) {
        if (this.propertyMappingTranslationService == propertyMappingTranslationService) {
            this.propertyMappingTranslationService = null;
        }
    }

    protected void bindTranslationDetailsManager(TranslationDetailsManager translationDetailsManager) {
        this.translationDetailsManager = translationDetailsManager;
    }

    protected void unbindTranslationDetailsManager(TranslationDetailsManager translationDetailsManager) {
        if (this.translationDetailsManager == translationDetailsManager) {
            this.translationDetailsManager = null;
        }
    }

    private class LoggingContextInvocationHandler
    implements InvocationHandler {
        private static final String PROJECT_ID_PARAM = "projectId";
        private final Object target;
        private final String projectId;

        LoggingContextInvocationHandler(Object target, String projectId) {
            this.target = target;
            this.projectId = projectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MDC.put((String)PROJECT_ID_PARAM, (String)this.projectId);
            try {
                Object object = method.invoke(this.target, args);
                return object;
            }
            finally {
                MDC.remove((String)PROJECT_ID_PARAM);
            }
        }
    }
}

