/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.api.TranslationState;
import com.smartling.aem.connector.core.impl.DelegatingTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkTranslationService
extends DelegatingTranslationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkTranslationService.class);

    BulkTranslationService(TranslationService translationService) {
        super(translationService);
    }

    @Override
    public TranslationConstants.TranslationStatus[] updateTranslationObjectsState(String jobId, TranslationObject[] translationObjects, TranslationState[] translationStates) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#updateTranslationObjectsState({},...)", (Object)jobId);
        TranslationConstants.TranslationStatus[] statuses = new TranslationConstants.TranslationStatus[translationObjects.length];
        for (int i = 0; i < translationObjects.length; ++i) {
            TranslationObject translationObject = translationObjects[i];
            TranslationState translationState = translationStates[i];
            try {
                statuses[i] = this.updateTranslationObjectState(jobId, translationObject, translationState);
                continue;
            }
            catch (TranslationException e) {
                LOGGER.error("Failed to update status of translation object '{}':", (Object)translationObject.getTitle(), (Object)e);
                statuses[i] = TranslationConstants.TranslationStatus.ERROR_UPDATE;
            }
        }
        return statuses;
    }

    @Override
    public TranslationConstants.TranslationStatus[] getTranslationObjectsStatus(String jobId, TranslationObject[] translationObjects) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#getTranslationObjectsStatus({},...)", (Object)jobId);
        TranslationConstants.TranslationStatus[] statuses = new TranslationConstants.TranslationStatus[translationObjects.length];
        for (int i = 0; i < translationObjects.length; ++i) {
            TranslationObject translationObject = translationObjects[i];
            try {
                statuses[i] = this.getTranslationObjectStatus(jobId, translationObject);
                continue;
            }
            catch (TranslationException e) {
                LOGGER.error("Failed to get status of translation object '{}':", (Object)translationObject.getTitle(), (Object)e);
                statuses[i] = TranslationConstants.TranslationStatus.ERROR_UPDATE;
            }
        }
        return statuses;
    }
}

