/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.update;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.update.UpdatesValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

@SlingServlet(paths={"/services/smartling/page/update/validator"})
public class UpdatesValidatorServlet
extends SmartlingBaseServlet {
    public static final String THERE_IS_NO_RESOURCE_ERROR_MESSAGE = "There is no resource for checking language copy";
    public static final String TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE = "Target locale codes are missing for checking parent page";
    @Reference
    private UpdatesValidator validator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        String[] targetLocaleCodesParam = request.getParameterValues("targetLocaleCodes");
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE);
            return;
        }
        boolean isDeep = Boolean.parseBoolean(request.getParameter("isDeep"));
        String[] excludedPaths = request.getParameterValues("excludedPaths");
        TreeSet<String> excludedPathSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        excludedPathSet.addAll(excludedPaths == null ? Collections.emptyList() : (Collection)Arrays.stream(excludedPaths).collect(Collectors.toList()));
        Set<String> targetLocaleCodes = Arrays.stream(targetLocaleCodesParam).collect(Collectors.toSet());
        targetLocaleCodes.remove("");
        try {
            List payloadPaths = this.getPayloadPaths(payloadPath, this.assetLanguageCopyManager).stream().map(path -> this.getResource((String)path, resourceResolver)).collect(Collectors.toList());
            for (Resource payloadResource : payloadPaths) {
                this.validator.validate(payloadResource, resourceResolver, targetLocaleCodes, isDeep, excludedPathSet);
            }
        }
        catch (SmartlingException | ResourceNotFoundException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    private Resource getResource(String path, ResourceResolver resourceResolver) {
        Resource resource = this.servletUtils.getResource(resourceResolver, path);
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new ResourceNotFoundException(path, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
        }
        return resource;
    }

    protected void bindValidator(UpdatesValidator updatesValidator) {
        this.validator = updatesValidator;
    }

    protected void unbindValidator(UpdatesValidator updatesValidator) {
        if (this.validator == updatesValidator) {
            this.validator = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }
}

