/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.page;

import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.ui.validator.page.TargetPageExistingValidator;
import com.smartling.aem.connector.core.Predicates;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Service
@Component
public class TargetPageExistingValidatorImpl
implements TargetPageExistingValidator {
    public static final String TARGET_PAGES_MISSED_MESSAGE_FORMAT = "Following target pages are missed: %s";

    @Override
    public void validate(Iterable<LanguageCopyManager.LanguageCopy> languageCopies, Set<String> requestedLocales) throws SmartlingException {
        List missedLanguageCopies = StreamSupport.stream(languageCopies.spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(requestedLocales))).filter(languageCopy -> !languageCopy.exists()).collect(Collectors.toList());
        if (!missedLanguageCopies.isEmpty()) {
            List missedPaths = missedLanguageCopies.stream().map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
            String missedPathsStr = StringUtils.join(missedPaths, (String)",");
            throw new SmartlingException(String.format(TARGET_PAGES_MISSED_MESSAGE_FORMAT, missedPathsStr));
        }
    }
}

