/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Service
@Component
public class TargetLocalesValidatorImpl
implements TargetLocalesValidator {
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;

    @Override
    public void validate(SmartlingCloudConfig cloudConfig, Set<String> requestedLocales) throws SmartlingException {
        Set projectLocales;
        Object smartlingLocale2;
        TreeSet<Object> mappedLocales = new TreeSet<Object>(String.CASE_INSENSITIVE_ORDER);
        for (String aemLocale : requestedLocales) {
            smartlingLocale2 = cloudConfig.getLanguageMapping().get(aemLocale);
            if (StringUtils.isBlank((CharSequence)smartlingLocale2)) {
                throw new SmartlingException(String.format("There is no mapping from AEM locale \"%s\" to a Smartling locale", aemLocale));
            }
            mappedLocales.add(smartlingLocale2);
        }
        try {
            ProjectApiClient client = this.projectApiClientFactory.createClient(cloudConfig);
            smartlingLocale2 = null;
            try {
                projectLocales = client.getProjectLocales().stream().map(smartlingLocale -> smartlingLocale.getLocaleId()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
            }
            catch (Throwable throwable) {
                smartlingLocale2 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (smartlingLocale2 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)smartlingLocale2).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SmartlingException("Error on retrieving project locales.", e);
        }
        Collection unsupportedLocales = mappedLocales.stream().filter(locale -> !projectLocales.contains(locale)).collect(Collectors.toSet());
        if (!unsupportedLocales.isEmpty()) {
            smartlingLocale2 = (String)unsupportedLocales.iterator().next();
            String aemLocale = cloudConfig.mapSmartlingCodeToLocale((String)smartlingLocale2).iterator().next();
            throw new SmartlingException(String.format("Smartling project doesn't contain language \"%s\" in order to translate AEM language \"%s\"", smartlingLocale2, aemLocale));
        }
    }

    protected void bindProjectApiClientFactory(ProjectApiClientFactory projectApiClientFactory) {
        this.projectApiClientFactory = projectApiClientFactory;
    }

    protected void unbindProjectApiClientFactory(ProjectApiClientFactory projectApiClientFactory) {
        if (this.projectApiClientFactory == projectApiClientFactory) {
            this.projectApiClientFactory = null;
        }
    }
}

