/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.locale.SourceLocaleValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/source/locale/validator"})
public class SourceLocaleValidatorServlet
extends SmartlingBaseServlet {
    @Reference
    private SourceLocaleValidator sourceLocaleValidator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String paths = this.servletUtils.getPayloadPath(request);
            String projectUid = request.getParameter("projectUid");
            String firstSourceLocale = null;
            String firstPath = null;
            for (String path : StringUtils.split((String)paths, (String)";")) {
                SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
                if (cloudConfig == null) {
                    return;
                }
                cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
                String sourceLocale = this.sourceLocaleValidator.validate(resourceResolver, cloudConfig, path);
                if (StringUtils.isBlank(firstSourceLocale)) {
                    firstSourceLocale = sourceLocale;
                    firstPath = path;
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)sourceLocale, (CharSequence)firstSourceLocale)) continue;
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format("Different source locales: %s, %s", firstPath, path));
                return;
            }
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    protected void bindSourceLocaleValidator(SourceLocaleValidator sourceLocaleValidator) {
        this.sourceLocaleValidator = sourceLocaleValidator;
    }

    protected void unbindSourceLocaleValidator(SourceLocaleValidator sourceLocaleValidator) {
        if (this.sourceLocaleValidator == sourceLocaleValidator) {
            this.sourceLocaleValidator = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    @Override
    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    @Override
    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

