/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;

@Service(value={SourceLocaleValidator.class})
@Component
public class SourceLocaleValidator {
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private FormLanguageCopyManager formLanguageCopyManager;

    public String validate(ResourceResolver resourceResolver, SmartlingCloudConfig cloudConfig, String sourcePath) throws SmartlingException {
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)sourcePath, (CharSequence)"/content/dam") ? this.assetLanguageCopyManager : (StringUtils.startsWithIgnoreCase((CharSequence)sourcePath, (CharSequence)"/content/forms") ? this.formLanguageCopyManager : this.pageLanguageCopyManager);
        Language language = languageCopyManager.getLanguage(resourceResolver, sourcePath);
        if (language == null) {
            throw new SmartlingException(String.format("Couldn't find source locale for path=\"%s\"", sourcePath));
        }
        String mappedLocale = cloudConfig.getLanguageMapping().get(language.getCode());
        if (StringUtils.isBlank((CharSequence)mappedLocale)) {
            throw new SmartlingException(String.format("There is no mapping for locale=\"%s\"", language.getCode()));
        }
        return language.getCode();
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    protected void bindFormLanguageCopyManager(FormLanguageCopyManager formLanguageCopyManager) {
        this.formLanguageCopyManager = formLanguageCopyManager;
    }

    protected void unbindFormLanguageCopyManager(FormLanguageCopyManager formLanguageCopyManager) {
        if (this.formLanguageCopyManager == formLanguageCopyManager) {
            this.formLanguageCopyManager = null;
        }
    }
}

