/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingProjectLocaleCredentials;
import com.smartling.aem.connector.core.impl.integration.AuthenticationException;
import com.smartling.aem.connector.core.impl.integration.NotFoundException;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClientFactory;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/cloud/config/connection/check"})
public class CloudConfigConnectionCheckServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConfigConnectionCheckServlet.class);
    static final String CONFIG_PATH_PARAMETER = "configPath";
    static final String PROJECT_NOT_FOUND = "User credentials don't match Project, change your Project ID or credentials.";
    static final String AUTHENTICATION_ERROR = "Couldn't authenticate credentials. Check your User Identifier and Token Secret.";
    public static final String ERROR_DURING_CHECKING_CONNECTION_FOR_SMARTLING_PROJECT = "Error during checking connection for smartling project";
    public static final String CLOUD_CONFIG_IS_ABSCENT_FOR_CONFIG_PATH = ", cloudConfig is abscent for config path";
    static final String DECRYPTION_ERROR = "Configurations have been encrypted. Please test your User Identifier and Token Secret.";
    @Reference
    private CloudConfigLocator cloudConfigLocator;
    @Reference
    private FileApiClientFactory fileApiClientFactory;
    @Reference
    private ServletUtils servletUtils;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        SmartlingCloudConfig cloudConfig;
        String configPath = request.getParameter(CONFIG_PATH_PARAMETER);
        if (!this.existsCloudConfig(response, configPath, cloudConfig = this.cloudConfigLocator.getCloudConfig(configPath, SmartlingCloudConfig.class))) {
            return;
        }
        if (!this.validateConfig(response, cloudConfig)) {
            return;
        }
        for (SmartlingProjectLocaleCredentials credentials : cloudConfig.getLocaleProjectConfigs()) {
            if (this.validateConfig(response, cloudConfig.getForLocale(credentials.getLocale()))) continue;
            return;
        }
    }

    private boolean validateConfig(@NotNull SlingHttpServletResponse response, SmartlingCloudConfig cloudConfig) throws IOException {
        try (FileApiClient client = this.fileApiClientFactory.createClient(cloudConfig);){
            client.getFilesList(cloudConfig.getProjectId());
        }
        catch (IllegalStateException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, DECRYPTION_ERROR);
            LOGGER.warn("Error during checking connection for smartling project {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
            return false;
        }
        catch (AuthenticationException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 401, AUTHENTICATION_ERROR);
            LOGGER.warn("Error during checking connection for smartling project {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
            return false;
        }
        catch (NotFoundException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 404, PROJECT_NOT_FOUND);
            LOGGER.warn("Error during checking connection for smartling project {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
            return false;
        }
        catch (Exception e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
            LOGGER.warn("Error during checking connection for smartling project {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
            return false;
        }
        return true;
    }

    private boolean existsCloudConfig(@Nonnull SlingHttpServletResponse response, String configPath, SmartlingCloudConfig cloudConfig) throws IOException {
        if (cloudConfig == null) {
            String errorMessage = String.format("Error during checking connection for smartling project, cloudConfig is abscent for config path %s", configPath);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, errorMessage);
            LOGGER.warn(errorMessage);
            return false;
        }
        return true;
    }

    protected void bindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        this.cloudConfigLocator = cloudConfigLocator;
    }

    protected void unbindCloudConfigLocator(CloudConfigLocator cloudConfigLocator) {
        if (this.cloudConfigLocator == cloudConfigLocator) {
            this.cloudConfigLocator = null;
        }
    }

    protected void bindFileApiClientFactory(FileApiClientFactory fileApiClientFactory) {
        this.fileApiClientFactory = fileApiClientFactory;
    }

    protected void unbindFileApiClientFactory(FileApiClientFactory fileApiClientFactory) {
        if (this.fileApiClientFactory == fileApiClientFactory) {
            this.fileApiClientFactory = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }
}

