/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.TranslationCloudConfigUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@SlingServlet(paths={"/services/smartling/debug/resolveConfig"})
public class ResolveResourceConfigServlet
extends SlingAllMethodsServlet {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private TranslationCloudConfigUtil translationCloudConfigUtil;

    public void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        String path = request.getParameter("path");
        try {
            Resource resource = resourceResolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                throw new ServletException(String.format("Resource for path \"%s\" can not be found for path", path));
            }
            String configPath = this.translationCloudConfigUtil.getCloudConfigPathAppliedOnResource(resource, MachineTranslationCloudConfig.class);
            if (configPath == null) {
                throw new ServletException("Cloud config path for resource \"" + path + "\" not found");
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            response.getWriter().write(configPath);
        }
        catch (IOException e) {
            throw new ServletException("Couldn't write config path out", (Throwable)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        this.translationCloudConfigUtil = translationCloudConfigUtil;
    }

    protected void unbindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        if (this.translationCloudConfigUtil == translationCloudConfigUtil) {
            this.translationCloudConfigUtil = null;
        }
    }
}

