/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.smartling.aem.connector.automation.impl.related.RelatedAssetsFactory;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsManager;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/debug/related-assets"})
public class RelatedAssetsServlet
extends SmartlingBaseServlet {
    @Reference
    private RelatedAssetsFactory relatedAssetsFactory;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String path = RelatedAssetsServlet.getMandatoryParameter(request, "path", "Mandatory \"path\" parameter is missing");
        try {
            RelatedAssetsManager relatedAssetsManager = this.relatedAssetsFactory.createManager(path, resourceResolver);
            List<String> relatedAssetPaths = relatedAssetsManager.getRelatedAssets(path);
            RelatedAssetsServlet.writeJson(response, relatedAssetPaths);
        }
        catch (SmartlingException e) {
            response.sendError(400, e.getMessage());
        }
    }

    protected void bindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        this.relatedAssetsFactory = relatedAssetsFactory;
    }

    protected void unbindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        if (this.relatedAssetsFactory == relatedAssetsFactory) {
            this.relatedAssetsFactory = null;
        }
    }
}

