/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.day.cq.dam.api.Asset;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.debug.dto.AssetDTO;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/debug/get-asset"})
public class GetAssetServlet
extends SmartlingBaseServlet {
    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String assetPath = GetAssetServlet.getMandatoryParameter(request, "path", "Mandatory asset \"path\" parameter is missing");
        try {
            Resource assetResource = resourceResolver.getResource(assetPath);
            Asset asset = (Asset)assetResource.adaptTo(Asset.class);
            AssetDTO dto = AssetDTO.builder().id(asset.getID()).mimeType(asset.getMimeType()).name(asset.getName()).path(asset.getPath()).isImage(this.isImage(resourceResolver, assetPath)).build();
            GetAssetServlet.writeJson(response, dto);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
        }
    }

    boolean isImage(@Nonnull ResourceResolver resourceResolver, String path) {
        String[] visualImageTypes = new String[]{"image/jpeg", "image/jpg", "image/png", "image/gif", "image/bmp", "image/tiff", "image/vnd.adobe.photoshop", "application/x-photoshop", "application/photoshop", "application/psd", "image/psd"};
        boolean condition = false;
        try {
            String mimeType;
            Resource contentRes = resourceResolver.getResource(path);
            Asset asset = (Asset)contentRes.adaptTo(Asset.class);
            if (asset != null && (mimeType = asset.getMimeType()) != null) {
                condition = Arrays.asList(visualImageTypes).contains(mimeType);
            }
        }
        catch (Exception e) {
            condition = false;
        }
        return condition;
    }
}

