/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.day.cq.dam.commons.util.DamLanguageUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsFactory;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsManager;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigMatchValidator;
import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.automation.ui.validator.page.TargetPageExistingValidator;
import com.smartling.aem.connector.automation.ui.validator.update.UpdatesValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SlingServlet(paths={"/services/smartling/debug/content"})
public class ContentDeepCheckServlet
extends SmartlingBaseServlet {
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    @Reference
    private RelatedAssetsFactory relatedAssetsFactory;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigMatchValidator cloudConfigMatchValidator;
    @Reference
    private TargetLocalesValidator targetLocalesValidator;
    @Reference
    private TargetPageExistingValidator targetPageExistingValidator;
    @Reference
    private UpdatesValidator updatesValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String path = ContentDeepCheckServlet.getMandatoryParameter(request, "path", "Mandatory \"path\" parameter is missing");
        if (resourceResolver.getResource(path) == null) {
            response.sendError(404, String.format("Couldn't find resource \"%s\"", path));
            return;
        }
        try {
            List<String> content = this.getAllContent(resourceResolver, path);
            TreeMap<String, String> contentValidation = new TreeMap<String, String>();
            for (String contentPath : content) {
                String message = this.validate(resourceResolver, contentPath);
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = "Success";
                }
                contentValidation.put(contentPath, message);
            }
            ContentDeepCheckServlet.writeJson(response, contentValidation);
        }
        catch (SmartlingException e) {
            response.sendError(400, e.getMessage());
        }
    }

    @NotNull
    private List<String> getAllContent(@NotNull ResourceResolver resourceResolver, String path) throws RelatedAssetsException {
        RelatedAssetsManager relatedAssetsManager = this.relatedAssetsFactory.createManager(path, resourceResolver);
        List<String> content = relatedAssetsManager.getRelatedAssets(path);
        content.add(path);
        if (!StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER) || StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)ASSET_ROOT_FOLDER)) {
            return content;
        }
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        if (pageManager == null) {
            return content;
        }
        Page page = pageManager.getPage(path);
        if (page == null) {
            return content;
        }
        Iterator children = page.listChildren(null, true);
        Iterable iterable = () -> children;
        List childrenPaths = StreamSupport.stream(iterable.spliterator(), false).map(Page::getPath).collect(Collectors.toList());
        content.addAll(childrenPaths);
        return content;
    }

    @Nullable
    private String validate(ResourceResolver resourceResolver, String contentPath) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentPath, (CharSequence)ASSET_ROOT_FOLDER)) {
            return this.validateAsset(resourceResolver, this.assetLanguageCopyManager, contentPath);
        }
        return this.validatePage(resourceResolver, this.pageLanguageCopyManager, contentPath);
    }

    @Nullable
    private String validatePage(ResourceResolver resourceResolver, PageLanguageCopyManager languageCopyManager, String path) {
        return this.validateCommon(resourceResolver, languageCopyManager, path);
    }

    @Nullable
    private String validateAsset(ResourceResolver resourceResolver, AssetLanguageCopyManager languageCopyManager, String path) {
        String error = ContentDeepCheckServlet.validateAssetLanguageRoot(resourceResolver, path);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error;
        }
        return this.validateCommon(resourceResolver, languageCopyManager, path);
    }

    @Nullable
    private String validateCommon(ResourceResolver resourceResolver, LanguageCopyManager languageCopyManager, String path) {
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, path);
        Set<String> targetLocaleCodes = StreamSupport.stream(languageCopies.spliterator(), false).map(languageCopy -> languageCopy.getLanguage().getCode()).collect(Collectors.toSet());
        String error = this.targetLocalesValidation(resourceResolver, targetLocaleCodes, path);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error;
        }
        error = this.targetParentValidation(resourceResolver, languageCopyManager, path);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error;
        }
        error = this.changedForTranslationValidation(resourceResolver, targetLocaleCodes, path);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error;
        }
        return this.validateCloudConfigMatch(resourceResolver, targetLocaleCodes, path);
    }

    @Nullable
    private static String validateAssetLanguageRoot(ResourceResolver resourceResolver, String path) {
        Collection languageRoots = DamLanguageUtil.getLanguageRoots((ResourceResolver)resourceResolver, (String)path);
        Optional<Resource> rootOpt = languageRoots.stream().filter(rootResource -> StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)rootResource.getPath())).findFirst();
        if (!rootOpt.isPresent()) {
            return "Couldn't find language root";
        }
        Resource root = rootOpt.get();
        if (root.getChild("jcr:content") == null) {
            return String.format("Language root \"%s\" doesn't have \"%s\".", root.getPath(), "jcr:content");
        }
        return null;
    }

    @Nullable
    private String validateCloudConfigMatch(ResourceResolver resourceResolver, Set<String> targetLocaleCodes, String path) {
        try {
            this.cloudConfigMatchValidator.validate(resourceResolver, path, targetLocaleCodes, null);
        }
        catch (SmartlingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @Nullable
    private String targetLocalesValidation(ResourceResolver resourceResolver, Set<String> targetLocaleCodes, String path) {
        try {
            SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                return String.format("No cloud configuration applied for \"%s\"", path);
            }
            this.targetLocalesValidator.validate(cloudConfig, targetLocaleCodes);
        }
        catch (SmartlingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @Nullable
    private String targetParentValidation(ResourceResolver resourceResolver, LanguageCopyManager languageCopyManager, String path) {
        String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, parentPath);
        Set<String> targetLocaleCodes = StreamSupport.stream(languageCopies.spliterator(), false).map(languageCopy -> languageCopy.getLanguage().getCode()).collect(Collectors.toSet());
        try {
            this.targetPageExistingValidator.validate(languageCopies, targetLocaleCodes);
        }
        catch (SmartlingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @Nullable
    private String changedForTranslationValidation(ResourceResolver resourceResolver, Set<String> targetLocaleCodes, String path) {
        Resource resource = resourceResolver.getResource(path);
        if (resource == null) {
            return String.format("No resource found by path=\"%s\"", path);
        }
        try {
            this.updatesValidator.validate(resource, resourceResolver, targetLocaleCodes, false, Collections.emptySet());
        }
        catch (SmartlingException ex) {
            return ex.getMessage();
        }
        return null;
    }

    protected void bindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        this.relatedAssetsFactory = relatedAssetsFactory;
    }

    protected void unbindRelatedAssetsFactory(RelatedAssetsFactory relatedAssetsFactory) {
        if (this.relatedAssetsFactory == relatedAssetsFactory) {
            this.relatedAssetsFactory = null;
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindCloudConfigMatchValidator(CloudConfigMatchValidator cloudConfigMatchValidator) {
        this.cloudConfigMatchValidator = cloudConfigMatchValidator;
    }

    protected void unbindCloudConfigMatchValidator(CloudConfigMatchValidator cloudConfigMatchValidator) {
        if (this.cloudConfigMatchValidator == cloudConfigMatchValidator) {
            this.cloudConfigMatchValidator = null;
        }
    }

    protected void bindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        this.targetLocalesValidator = targetLocalesValidator;
    }

    protected void unbindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        if (this.targetLocalesValidator == targetLocalesValidator) {
            this.targetLocalesValidator = null;
        }
    }

    protected void bindTargetPageExistingValidator(TargetPageExistingValidator targetPageExistingValidator) {
        this.targetPageExistingValidator = targetPageExistingValidator;
    }

    protected void unbindTargetPageExistingValidator(TargetPageExistingValidator targetPageExistingValidator) {
        if (this.targetPageExistingValidator == targetPageExistingValidator) {
            this.targetPageExistingValidator = null;
        }
    }

    protected void bindUpdatesValidator(UpdatesValidator updatesValidator) {
        this.updatesValidator = updatesValidator;
    }

    protected void unbindUpdatesValidator(UpdatesValidator updatesValidator) {
        if (this.updatesValidator == updatesValidator) {
            this.updatesValidator = null;
        }
    }
}

