/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.callback.SmartlingCallbackValidator;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationJobHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/sync-translation"})
public class SyncTranslationServlet
extends SmartlingBaseServlet {
    public static final String SERVICES_SMARTLING_SYNC_TRANSLATION_ENDPOINT = "/services/smartling/sync-translation";
    public static final String FILE_URI_PARAM = "fileUri";
    public static final String LOCALE_PARAM = "locale";
    @Reference
    private SyncTranslationJobHandler syncTranslationJobHandler;
    @Reference
    private SmartlingCallbackValidator callbackValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String fileUri = request.getParameter(FILE_URI_PARAM);
        String locale = request.getParameter(LOCALE_PARAM);
        if (StringUtils.isBlank((CharSequence)fileUri) || StringUtils.isBlank((CharSequence)locale)) {
            response.sendError(400, "Mandatory parameter must be specified.");
            return;
        }
        if (!this.callbackValidator.isSignatureMissedOrValid((HttpServletRequest)request)) {
            response.sendError(400, "Signature validation failed.");
            return;
        }
        try {
            this.syncTranslationJobHandler.syncTranslationObject(fileUri);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            response.getWriter().print("SUCCESS");
        }
        catch (SmartlingException e) {
            response.sendError(400, e.getMessage());
        }
    }

    protected void bindSyncTranslationJobHandler(SyncTranslationJobHandler syncTranslationJobHandler) {
        this.syncTranslationJobHandler = syncTranslationJobHandler;
    }

    protected void unbindSyncTranslationJobHandler(SyncTranslationJobHandler syncTranslationJobHandler) {
        if (this.syncTranslationJobHandler == syncTranslationJobHandler) {
            this.syncTranslationJobHandler = null;
        }
    }

    protected void bindCallbackValidator(SmartlingCallbackValidator smartlingCallbackValidator) {
        this.callbackValidator = smartlingCallbackValidator;
    }

    protected void unbindCallbackValidator(SmartlingCallbackValidator smartlingCallbackValidator) {
        if (this.callbackValidator == smartlingCallbackValidator) {
            this.callbackValidator = null;
        }
    }
}

