/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigChildPageValidator;
import com.smartling.aem.connector.automation.ui.validator.features.CloudConfigFeatureValidator;
import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.automation.ui.validator.name.UniqueJobNameValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

@Service(value={SmartlingJobWorkflowServletValidator.class})
@Component
public class SmartlingJobWorkflowServletValidator {
    @Reference
    private CloudConfigFeatureValidator cloudConfigFeatureValidator;
    @Reference
    private UniqueJobNameValidator uniqueJobNameValidator;
    @Reference
    private TargetLocalesValidator targetLocalesValidator;
    @Reference
    private CloudConfigChildPageValidator cloudConfigChildPageValidator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    public void validateConfig(SlingHttpServletRequest request, ResourceResolver resourceResolver) throws SmartlingException {
        String payload = StringUtils.defaultString((String)this.servletUtils.getPayloadPath(request));
        String projectUid = request.getParameter("projectUid");
        List paths = Arrays.stream(StringUtils.split((String)payload, (String)";")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(paths)) {
            throw new SmartlingValidationException("No payload provided");
        }
        try {
            SmartlingCloudConfig cloudConfig = null;
            MachineTranslationCloudConfig machineTranslationCloudConfig = null;
            for (String path : paths) {
                cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
                if (cloudConfig == null) {
                    throw new SmartlingValidationException("There is no Smartling config associated with the resource=\"" + path + "\"");
                }
                cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
                machineTranslationCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, MachineTranslationCloudConfig.class);
                if (machineTranslationCloudConfig == null) {
                    throw new SmartlingValidationException("There is no translation integration config associated with the resource=\"" + path + "\"");
                }
                this.cloudConfigFeatureValidator.validate(machineTranslationCloudConfig);
            }
            String jobName = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobName"), null);
            String jobUid = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobUid"), null);
            this.uniqueJobNameValidator.validate(jobName, cloudConfig, jobUid);
            String[] targetLocaleCodes = request.getParameterValues("targetLocaleCodes");
            Set<String> targetLocaleCodesSet = new HashSet<String>(Arrays.asList(targetLocaleCodes)).stream().filter(el -> !StringUtils.isEmpty((CharSequence)el)).collect(Collectors.toSet());
            this.targetLocalesValidator.validate(cloudConfig, targetLocaleCodesSet);
        }
        catch (SmartlingException e) {
            throw new SmartlingValidationException("Config validation failed", e);
        }
    }

    public void validateChildResourceConfig(String path, ResourceResolver resourceResolver) throws SmartlingValidationException {
        try {
            this.cloudConfigChildPageValidator.validate(resourceResolver, path);
        }
        catch (SmartlingException e) {
            throw new SmartlingValidationException("Child resource config validation failed", e);
        }
    }

    protected void bindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        this.cloudConfigFeatureValidator = cloudConfigFeatureValidator;
    }

    protected void unbindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        if (this.cloudConfigFeatureValidator == cloudConfigFeatureValidator) {
            this.cloudConfigFeatureValidator = null;
        }
    }

    protected void bindUniqueJobNameValidator(UniqueJobNameValidator uniqueJobNameValidator) {
        this.uniqueJobNameValidator = uniqueJobNameValidator;
    }

    protected void unbindUniqueJobNameValidator(UniqueJobNameValidator uniqueJobNameValidator) {
        if (this.uniqueJobNameValidator == uniqueJobNameValidator) {
            this.uniqueJobNameValidator = null;
        }
    }

    protected void bindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        this.targetLocalesValidator = targetLocalesValidator;
    }

    protected void unbindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        if (this.targetLocalesValidator == targetLocalesValidator) {
            this.targetLocalesValidator = null;
        }
    }

    protected void bindCloudConfigChildPageValidator(CloudConfigChildPageValidator cloudConfigChildPageValidator) {
        this.cloudConfigChildPageValidator = cloudConfigChildPageValidator;
    }

    protected void unbindCloudConfigChildPageValidator(CloudConfigChildPageValidator cloudConfigChildPageValidator) {
        if (this.cloudConfigChildPageValidator == cloudConfigChildPageValidator) {
            this.cloudConfigChildPageValidator = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

